/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal.forms;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.IanaLinkRelations;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.MediaTypes;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.mediatype.hal.HalLinkRelation;
import org.springframework.hateoas.mediatype.hal.Jackson2HalModule;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsAffordanceModel;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsDocument;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsTemplate;
import org.springframework.http.HttpMethod;

class HalFormsSerializers {
    HalFormsSerializers() {
    }

    private static Map<String, HalFormsTemplate> findTemplates(RepresentationModel<?> resource) {
        if (!resource.hasLink(IanaLinkRelations.SELF)) {
            return Collections.emptyMap();
        }
        HashMap<String, HalFormsTemplate> templates = new HashMap<String, HalFormsTemplate>();
        List affordances = resource.getLink(IanaLinkRelations.SELF).map(Link::getAffordances).orElse(Collections.emptyList());
        affordances.stream().map(it -> it.getAffordanceModel(MediaTypes.HAL_FORMS_JSON)).map(HalFormsAffordanceModel.class::cast).filter(it -> !it.hasHttpMethod(HttpMethod.GET)).peek(it -> HalFormsSerializers.validate(resource, it)).forEach(it -> {
            HalFormsTemplate template = HalFormsTemplate.forMethod(it.getHttpMethod()).withProperties(it.getInputProperties());
            templates.put(templates.isEmpty() ? "default" : it.getName(), template);
        });
        return templates;
    }

    private static void validate(RepresentationModel<?> resource, HalFormsAffordanceModel model) {
        String selfLinkUri;
        String affordanceUri = model.getURI();
        if (!affordanceUri.equals(selfLinkUri = resource.getRequiredLink(IanaLinkRelations.SELF.value()).expand(new Object[0]).getHref())) {
            throw new IllegalStateException("Affordance's URI " + affordanceUri + " doesn't match self link " + selfLinkUri + " as expected in HAL-FORMS");
        }
    }

    static class HalFormsResourcesSerializer
    extends ContainerSerializer<CollectionModel<?>>
    implements ContextualSerializer {
        private static final long serialVersionUID = -3601146866067500734L;
        private final BeanProperty property;
        private final Jackson2HalModule.EmbeddedMapper embeddedMapper;

        HalFormsResourcesSerializer(BeanProperty property, Jackson2HalModule.EmbeddedMapper embeddedMapper) {
            super(CollectionModel.class, false);
            this.property = property;
            this.embeddedMapper = embeddedMapper;
        }

        HalFormsResourcesSerializer(Jackson2HalModule.EmbeddedMapper embeddedMapper) {
            this(null, embeddedMapper);
        }

        public void serialize(CollectionModel<?> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            Map<HalLinkRelation, Object> embeddeds = this.embeddedMapper.map(value);
            HalFormsDocument<?> doc = value instanceof PagedModel ? HalFormsDocument.empty().withEmbedded(embeddeds).withPageMetadata(((PagedModel)value).getMetadata()).withLinks(value.getLinks()).withTemplates(HalFormsSerializers.findTemplates(value)) : HalFormsDocument.empty().withEmbedded(embeddeds).withLinks(value.getLinks()).withTemplates(HalFormsSerializers.findTemplates(value));
            provider.findValueSerializer(HalFormsDocument.class, this.property).serialize(doc, gen, provider);
        }

        public JavaType getContentType() {
            return null;
        }

        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        public boolean hasSingleElement(CollectionModel<?> resources) {
            return resources.getContent().size() == 1;
        }

        protected ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer typeSerializer) {
            return null;
        }

        public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
            return new HalFormsResourcesSerializer(property, this.embeddedMapper);
        }
    }

    static class HalFormsResourceSerializer
    extends ContainerSerializer<EntityModel<?>>
    implements ContextualSerializer {
        private static final long serialVersionUID = -7912243216469101379L;
        private final BeanProperty property;

        HalFormsResourceSerializer(BeanProperty property) {
            super(EntityModel.class, false);
            this.property = property;
        }

        HalFormsResourceSerializer() {
            this(null);
        }

        public void serialize(EntityModel<?> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            HalFormsDocument<?> doc = HalFormsDocument.forResource(value.getContent()).withLinks(value.getLinks()).withTemplates(HalFormsSerializers.findTemplates(value));
            provider.findValueSerializer(HalFormsDocument.class, this.property).serialize(doc, gen, provider);
        }

        public JavaType getContentType() {
            return null;
        }

        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        public boolean hasSingleElement(EntityModel<?> resource) {
            return false;
        }

        protected ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer typeSerializer) {
            return null;
        }

        public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
            return new HalFormsResourceSerializer(property);
        }
    }
}

