/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.config;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.core.io.Resource;
import org.springframework.hateoas.client.LinkDiscoverer;
import org.springframework.hateoas.client.LinkDiscoverers;
import org.springframework.hateoas.config.EntityLinksConfiguration;
import org.springframework.hateoas.mediatype.MessageResolver;
import org.springframework.hateoas.server.LinkRelationProvider;
import org.springframework.hateoas.server.core.AnnotationLinkRelationProvider;
import org.springframework.hateoas.server.core.DefaultLinkRelationProvider;
import org.springframework.hateoas.server.core.DelegatingLinkRelationProvider;
import org.springframework.hateoas.server.core.EvoInflectorLinkRelationProvider;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.plugin.core.config.EnablePluginRegistries;
import org.springframework.plugin.core.support.PluginRegistryFactoryBean;
import org.springframework.util.ClassUtils;

@Configuration
@Import(value={EntityLinksConfiguration.class})
@EnablePluginRegistries(value={LinkDiscoverer.class})
public class HateoasConfiguration {
    @Autowired
    private ApplicationContext context;

    @Bean
    public MessageResolver messageResolver() {
        return MessageResolver.of((MessageSource)this.lookupMessageSource());
    }

    @Bean
    LinkRelationProvider defaultRelProvider() {
        return ClassUtils.isPresent((String)"org.atteo.evo.inflector.English", null) ? new EvoInflectorLinkRelationProvider() : new DefaultLinkRelationProvider();
    }

    @Bean
    AnnotationLinkRelationProvider annotationRelProvider() {
        return new AnnotationLinkRelationProvider();
    }

    @Primary
    @Bean
    DelegatingLinkRelationProvider _relProvider(PluginRegistry<LinkRelationProvider, LinkRelationProvider.LookupContext> relProviderPluginRegistry) {
        return new DelegatingLinkRelationProvider(relProviderPluginRegistry);
    }

    @Bean
    PluginRegistryFactoryBean<LinkRelationProvider, LinkRelationProvider.LookupContext> relProviderPluginRegistry() {
        PluginRegistryFactoryBean factory = new PluginRegistryFactoryBean();
        factory.setType(LinkRelationProvider.class);
        factory.setExclusions(new Class[]{DelegatingLinkRelationProvider.class});
        return factory;
    }

    @Bean
    LinkDiscoverers linkDiscoverers(PluginRegistry<LinkDiscoverer, MediaType> discoverers) {
        return new LinkDiscoverers(discoverers);
    }

    @Nullable
    private final AbstractMessageSource lookupMessageSource() {
        List<Resource> candidates = this.loadProperties("rest-default-messages", false);
        if (candidates.isEmpty() && this.loadProperties("rest-messages", true).isEmpty()) {
            return null;
        }
        ReloadableResourceBundleMessageSource messageSource = new ReloadableResourceBundleMessageSource();
        messageSource.setBasename("classpath:rest-messages");
        messageSource.setDefaultEncoding(StandardCharsets.UTF_8.toString());
        if (!candidates.isEmpty()) {
            messageSource.setCommonMessages(this.loadProperties(candidates));
        }
        return messageSource;
    }

    @Nullable
    private final Properties loadProperties(List<Resource> sources) {
        Resource[] resources = (Resource[])this.loadProperties("rest-default-messages", false).stream().toArray(Resource[]::new);
        PropertiesFactoryBean factory = new PropertiesFactoryBean();
        factory.setLocations(resources);
        try {
            factory.afterPropertiesSet();
            return factory.getObject();
        }
        catch (IOException o_O) {
            throw new IllegalStateException("Could not load default properties from resources!", o_O);
        }
    }

    private final List<Resource> loadProperties(String baseName, boolean withWildcard) {
        try {
            return Arrays.stream(this.context.getResources(String.format("classpath:%s%s.properties", baseName, withWildcard ? "*" : ""))).filter(Resource::exists).collect(Collectors.toList());
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }
}

