/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal.forms;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.core.ResolvableType;
import org.springframework.hateoas.mediatype.hal.HalConfiguration;

public class HalFormsConfiguration {
    private final HalConfiguration halConfiguration;
    private final Map<Class<?>, String> patterns = new HashMap();

    public HalFormsConfiguration() {
        this.halConfiguration = new HalConfiguration();
    }

    public HalFormsConfiguration(HalConfiguration halConfiguration) {
        this.halConfiguration = halConfiguration;
    }

    public HalFormsConfiguration registerPattern(Class<?> type, String pattern) {
        this.patterns.put(type, pattern);
        return this;
    }

    Optional<String> getTypePatternFor(ResolvableType type) {
        return Optional.ofNullable(this.patterns.get(type.resolve(Object.class)));
    }

    public HalConfiguration getHalConfiguration() {
        return this.halConfiguration;
    }
}

