/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.config;

import java.util.Arrays;
import java.util.Map;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.hateoas.support.WebStack;

class WebStackImportSelector
implements ImportSelector {
    private static final String WEB_STACK_MISSING = "At least one web stack has to be selected in @EnableHypermediaSupport on %s!";

    WebStackImportSelector() {
    }

    public String[] selectImports(AnnotationMetadata metadata) {
        Map attributes = metadata.getAnnotationAttributes(EnableHypermediaSupport.class.getName());
        if (attributes == null) {
            return new String[0];
        }
        WebStack[] stacks = (WebStack[])attributes.get("stacks");
        if (stacks == null || stacks.length == 0) {
            throw new IllegalStateException(String.format(WEB_STACK_MISSING, metadata.getClassName()));
        }
        return (String[])Arrays.stream(stacks).flatMap(webStack -> webStack.getAvailableConfigurations().stream()).toArray(String[]::new);
    }
}

