/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.channel;

import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.FanoutExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.integration.amqp.channel.AbstractSubscribableAmqpChannel;
import org.springframework.integration.dispatcher.BroadcastingDispatcher;
import org.springframework.integration.dispatcher.MessageDispatcher;

public class PublishSubscribeAmqpChannel
extends AbstractSubscribableAmqpChannel {
    private volatile FanoutExchange exchange;

    public PublishSubscribeAmqpChannel(String channelName, SimpleMessageListenerContainer container, AmqpTemplate amqpTemplate) {
        super(channelName, container, amqpTemplate);
    }

    public void setExchange(FanoutExchange exchange) {
        this.exchange = exchange;
    }

    protected Queue initializeQueue(AmqpAdmin admin, String channelName) {
        if (this.exchange == null) {
            String exchangeName = "si.fanout." + channelName;
            this.exchange = new FanoutExchange(exchangeName);
        }
        admin.declareExchange((Exchange)this.exchange);
        Queue queue = admin.declareQueue();
        Binding binding = BindingBuilder.bind((Queue)queue).to(this.exchange);
        admin.declareBinding(binding);
        return queue;
    }

    protected MessageDispatcher createDispatcher() {
        return new BroadcastingDispatcher();
    }

    protected String getExchangeName() {
        return this.exchange != null ? this.exchange.getName() : "";
    }
}

