/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.channel;

import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.integration.Message;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.util.Assert;

public abstract class AbstractAmqpChannel
extends AbstractMessageChannel {
    private final AmqpTemplate amqpTemplate;

    AbstractAmqpChannel(AmqpTemplate amqpTemplate) {
        Assert.notNull((Object)amqpTemplate, (String)"amqpTemplate must not be null");
        this.amqpTemplate = amqpTemplate;
    }

    protected String getExchangeName() {
        return "";
    }

    protected String getRoutingKey() {
        return "";
    }

    AmqpTemplate getAmqpTemplate() {
        return this.amqpTemplate;
    }

    protected boolean doSend(Message<?> message, long timeout) {
        this.amqpTemplate.convertAndSend(this.getExchangeName(), this.getRoutingKey(), message);
        return true;
    }
}

