/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.outbound;

import java.util.Map;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.support.CorrelationData;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.integration.Message;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.amqp.support.AmqpHeaderMapper;
import org.springframework.integration.amqp.support.DefaultAmqpHeaderMapper;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.handler.ExpressionEvaluatingMessageProcessor;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.util.Assert;

public class AmqpOutboundEndpoint
extends AbstractReplyProducingMessageHandler
implements RabbitTemplate.ConfirmCallback,
RabbitTemplate.ReturnCallback {
    private static final ExpressionParser expressionParser = new SpelExpressionParser(new SpelParserConfiguration(true, true));
    private final AmqpTemplate amqpTemplate;
    private volatile boolean expectReply;
    private volatile String exchangeName;
    private volatile String routingKey;
    private volatile String exchangeNameExpression;
    private volatile String routingKeyExpression;
    private volatile ExpressionEvaluatingMessageProcessor<String> routingKeyGenerator;
    private volatile ExpressionEvaluatingMessageProcessor<String> exchangeNameGenerator;
    private volatile AmqpHeaderMapper headerMapper = new DefaultAmqpHeaderMapper();
    private volatile String confirmCorrelationExpression;
    private volatile ExpressionEvaluatingMessageProcessor<Object> correlationDataGenerator;
    private volatile MessageChannel confirmAckChannel;
    private volatile MessageChannel confirmNackChannel;
    private volatile MessageChannel returnChannel;

    protected void doInit() {
        Expression expression;
        Assert.state((this.exchangeNameExpression == null || this.exchangeName == null ? 1 : 0) != 0, (String)"Either an exchangeName or an exchangeNameExpression can be provided, but not both");
        Assert.state((this.confirmCorrelationExpression == null || !this.expectReply ? 1 : 0) != 0, (String)"Confirm correlation expression does not apply to a gateway");
        BeanFactory beanFactory = this.getBeanFactory();
        if (this.exchangeNameExpression != null) {
            expression = expressionParser.parseExpression(this.exchangeNameExpression);
            this.exchangeNameGenerator = new ExpressionEvaluatingMessageProcessor(expression, String.class);
            if (beanFactory != null) {
                this.exchangeNameGenerator.setBeanFactory(beanFactory);
            }
        }
        Assert.state((this.routingKeyExpression == null || this.routingKey == null ? 1 : 0) != 0, (String)"Either a routingKey or a routingKeyExpression can be provided, but not both");
        if (this.routingKeyExpression != null) {
            expression = expressionParser.parseExpression(this.routingKeyExpression);
            this.routingKeyGenerator = new ExpressionEvaluatingMessageProcessor(expression, String.class);
            if (beanFactory != null) {
                this.routingKeyGenerator.setBeanFactory(beanFactory);
            }
        }
        if (this.confirmCorrelationExpression != null) {
            expression = expressionParser.parseExpression(this.confirmCorrelationExpression);
            this.correlationDataGenerator = new ExpressionEvaluatingMessageProcessor(expression, Object.class);
            Assert.isTrue((boolean)(this.amqpTemplate instanceof RabbitTemplate), (String)"RabbitTemplate implementation is required for publisher confirms");
            ((RabbitTemplate)this.amqpTemplate).setConfirmCallback((RabbitTemplate.ConfirmCallback)this);
            if (beanFactory != null) {
                this.correlationDataGenerator.setBeanFactory(beanFactory);
            }
        }
        if (this.returnChannel != null) {
            Assert.isTrue((boolean)(this.amqpTemplate instanceof RabbitTemplate), (String)"RabbitTemplate implementation is required for publisher returns");
            ((RabbitTemplate)this.amqpTemplate).setReturnCallback((RabbitTemplate.ReturnCallback)this);
        }
    }

    public AmqpOutboundEndpoint(AmqpTemplate amqpTemplate) {
        Assert.notNull((Object)amqpTemplate, (String)"amqpTemplate must not be null");
        this.amqpTemplate = amqpTemplate;
    }

    public void setHeaderMapper(AmqpHeaderMapper headerMapper) {
        Assert.notNull((Object)headerMapper, (String)"headerMapper must not be null");
        this.headerMapper = headerMapper;
    }

    public void setExchangeName(String exchangeName) {
        Assert.notNull((Object)exchangeName, (String)"exchangeName must not be null");
        this.exchangeName = exchangeName;
    }

    public void setExchangeNameExpression(String exchangeNameExpression) {
        this.exchangeNameExpression = exchangeNameExpression;
    }

    public void setRoutingKey(String routingKey) {
        Assert.notNull((Object)routingKey, (String)"routingKey must not be null");
        this.routingKey = routingKey;
    }

    public void setRoutingKeyExpression(String routingKeyExpression) {
        this.routingKeyExpression = routingKeyExpression;
    }

    public void setExpectReply(boolean expectReply) {
        this.expectReply = expectReply;
    }

    public void setConfirmCorrelationExpression(String confirmCorrelationExpression) {
        this.confirmCorrelationExpression = confirmCorrelationExpression;
    }

    public void setConfirmAckChannel(MessageChannel ackChannel) {
        this.confirmAckChannel = ackChannel;
    }

    public void setConfirmNackChannel(MessageChannel nackChannel) {
        this.confirmNackChannel = nackChannel;
    }

    public void setReturnChannel(MessageChannel returnChannel) {
        this.returnChannel = returnChannel;
    }

    public String getComponentType() {
        return this.expectReply ? "amqp:outbound-gateway" : "amqp:outbound-channel-adapter";
    }

    protected Object handleRequestMessage(Message<?> requestMessage) {
        Object userCorrelationData;
        String exchangeName = this.exchangeName;
        String routingKey = this.routingKey;
        Object correlationData = null;
        if (this.correlationDataGenerator != null && (userCorrelationData = this.correlationDataGenerator.processMessage(requestMessage)) != null) {
            correlationData = userCorrelationData instanceof CorrelationData ? (CorrelationData)userCorrelationData : new CorrelationDataWrapper(requestMessage.getHeaders().getId().toString(), userCorrelationData);
        }
        if (this.exchangeNameGenerator != null) {
            exchangeName = (String)this.exchangeNameGenerator.processMessage(requestMessage);
        }
        if (this.routingKeyGenerator != null) {
            routingKey = (String)this.routingKeyGenerator.processMessage(requestMessage);
        }
        if (this.expectReply) {
            return this.sendAndReceive(exchangeName, routingKey, requestMessage);
        }
        this.send(exchangeName, routingKey, requestMessage, (CorrelationData)correlationData);
        return null;
    }

    private void send(String exchangeName, String routingKey, final Message<?> requestMessage, CorrelationData correlationData) {
        if (this.amqpTemplate instanceof RabbitTemplate) {
            ((RabbitTemplate)this.amqpTemplate).convertAndSend(exchangeName, routingKey, requestMessage.getPayload(), new MessagePostProcessor(){

                public org.springframework.amqp.core.Message postProcessMessage(org.springframework.amqp.core.Message message) throws AmqpException {
                    AmqpOutboundEndpoint.this.headerMapper.fromHeadersToRequest(requestMessage.getHeaders(), message.getMessageProperties());
                    return message;
                }
            }, correlationData);
        } else {
            this.amqpTemplate.convertAndSend(exchangeName, routingKey, requestMessage.getPayload(), new MessagePostProcessor(){

                public org.springframework.amqp.core.Message postProcessMessage(org.springframework.amqp.core.Message message) throws AmqpException {
                    AmqpOutboundEndpoint.this.headerMapper.fromHeadersToRequest(requestMessage.getHeaders(), message.getMessageProperties());
                    return message;
                }
            });
        }
    }

    private Message<?> sendAndReceive(String exchangeName, String routingKey, Message<?> requestMessage) {
        Assert.isTrue((boolean)(this.amqpTemplate instanceof RabbitTemplate), (String)"RabbitTemplate implementation is required for send and receive");
        MessageConverter converter = ((RabbitTemplate)this.amqpTemplate).getMessageConverter();
        MessageProperties amqpMessageProperties = new MessageProperties();
        org.springframework.amqp.core.Message amqpMessage = converter.toMessage(requestMessage.getPayload(), amqpMessageProperties);
        this.headerMapper.fromHeadersToRequest(requestMessage.getHeaders(), amqpMessageProperties);
        org.springframework.amqp.core.Message amqpReplyMessage = this.amqpTemplate.sendAndReceive(exchangeName, routingKey, amqpMessage);
        if (amqpReplyMessage == null) {
            return null;
        }
        Object replyObject = converter.fromMessage(amqpReplyMessage);
        MessageBuilder builder = replyObject instanceof Message ? MessageBuilder.fromMessage((Message)((Message)replyObject)) : MessageBuilder.withPayload((Object)replyObject);
        Map headers = this.headerMapper.toHeadersFromReply(amqpReplyMessage.getMessageProperties());
        builder.copyHeadersIfAbsent(headers);
        return builder.build();
    }

    public void confirm(CorrelationData correlationData, boolean ack) {
        Object userCorrelationData = correlationData;
        if (correlationData instanceof CorrelationDataWrapper) {
            userCorrelationData = ((CorrelationDataWrapper)correlationData).getUserData();
        }
        Message confirmMessage = MessageBuilder.withPayload((Object)userCorrelationData).setHeader("amqp_publishConfirm", (Object)ack).build();
        if (ack && this.confirmAckChannel != null) {
            this.confirmAckChannel.send(confirmMessage);
        } else if (!ack && this.confirmNackChannel != null) {
            this.confirmNackChannel.send(confirmMessage);
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Nowhere to send publisher confirm " + (ack ? "ack" : "nack") + " for " + userCorrelationData));
        }
    }

    public void returnedMessage(org.springframework.amqp.core.Message message, int replyCode, String replyText, String exchange, String routingKey) {
        MessageConverter converter = ((RabbitTemplate)this.amqpTemplate).getMessageConverter();
        Object returnedObject = converter.fromMessage(message);
        MessageBuilder builder = returnedObject instanceof Message ? MessageBuilder.fromMessage((Message)((Message)returnedObject)) : MessageBuilder.withPayload((Object)returnedObject);
        Map headers = this.headerMapper.toHeadersFromReply(message.getMessageProperties());
        builder.copyHeadersIfAbsent(headers).setHeader("amqp_returnReplyCode", (Object)replyCode).setHeader("amqp_returnReplyText", (Object)replyText).setHeader("amqp_returnExchange", (Object)exchange).setHeader("amqp_returnRoutingKey", (Object)routingKey);
        this.returnChannel.send(builder.build());
    }

    private static class CorrelationDataWrapper
    extends CorrelationData {
        private final Object userData;

        public CorrelationDataWrapper(String id, Object userData) {
            super(id);
            this.userData = userData;
        }

        public Object getUserData() {
            return this.userData;
        }
    }
}

