/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.dsl;

import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.AsyncRabbitTemplate;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.listener.DirectMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.integration.amqp.dsl.AmqpAsyncOutboundGatewaySpec;
import org.springframework.integration.amqp.dsl.AmqpInboundChannelAdapterDMLCSpec;
import org.springframework.integration.amqp.dsl.AmqpInboundChannelAdapterSMLCSpec;
import org.springframework.integration.amqp.dsl.AmqpInboundGatewayDMLCSpec;
import org.springframework.integration.amqp.dsl.AmqpInboundGatewaySMLCSpec;
import org.springframework.integration.amqp.dsl.AmqpMessageChannelSpec;
import org.springframework.integration.amqp.dsl.AmqpOutboundEndpointSpec;
import org.springframework.integration.amqp.dsl.AmqpPollableMessageChannelSpec;
import org.springframework.integration.amqp.dsl.AmqpPublishSubscribeMessageChannelSpec;

public final class Amqp {
    public static AmqpInboundGatewaySMLCSpec inboundGateway(ConnectionFactory connectionFactory, String ... queueNames) {
        SimpleMessageListenerContainer listenerContainer = new SimpleMessageListenerContainer(connectionFactory);
        listenerContainer.setQueueNames(queueNames);
        return Amqp.inboundGateway(listenerContainer);
    }

    public static AmqpInboundGatewaySMLCSpec inboundGateway(ConnectionFactory connectionFactory, AmqpTemplate amqpTemplate, String ... queueNames) {
        SimpleMessageListenerContainer listenerContainer = new SimpleMessageListenerContainer(connectionFactory);
        listenerContainer.setQueueNames(queueNames);
        return Amqp.inboundGateway(listenerContainer, amqpTemplate);
    }

    public static AmqpInboundGatewaySMLCSpec inboundGateway(ConnectionFactory connectionFactory, Queue ... queues) {
        SimpleMessageListenerContainer listenerContainer = new SimpleMessageListenerContainer(connectionFactory);
        listenerContainer.setQueues(queues);
        return Amqp.inboundGateway(listenerContainer);
    }

    public static AmqpInboundGatewaySMLCSpec inboundGateway(ConnectionFactory connectionFactory, AmqpTemplate amqpTemplate, Queue ... queues) {
        SimpleMessageListenerContainer listenerContainer = new SimpleMessageListenerContainer(connectionFactory);
        listenerContainer.setQueues(queues);
        return Amqp.inboundGateway(listenerContainer, amqpTemplate);
    }

    public static AmqpInboundGatewaySMLCSpec inboundGateway(SimpleMessageListenerContainer listenerContainer) {
        return new AmqpInboundGatewaySMLCSpec(listenerContainer);
    }

    public static AmqpInboundGatewaySMLCSpec inboundGateway(SimpleMessageListenerContainer listenerContainer, AmqpTemplate amqpTemplate) {
        return new AmqpInboundGatewaySMLCSpec(listenerContainer, amqpTemplate);
    }

    public static AmqpInboundGatewayDMLCSpec inboundGateway(DirectMessageListenerContainer listenerContainer) {
        return new AmqpInboundGatewayDMLCSpec(listenerContainer);
    }

    public static AmqpInboundGatewayDMLCSpec inboundGateway(DirectMessageListenerContainer listenerContainer, AmqpTemplate amqpTemplate) {
        return new AmqpInboundGatewayDMLCSpec(listenerContainer, amqpTemplate);
    }

    public static AmqpInboundChannelAdapterSMLCSpec inboundAdapter(ConnectionFactory connectionFactory, String ... queueNames) {
        SimpleMessageListenerContainer listenerContainer = new SimpleMessageListenerContainer(connectionFactory);
        listenerContainer.setQueueNames(queueNames);
        return new AmqpInboundChannelAdapterSMLCSpec(listenerContainer);
    }

    public static AmqpInboundChannelAdapterSMLCSpec inboundAdapter(ConnectionFactory connectionFactory, Queue ... queues) {
        SimpleMessageListenerContainer listenerContainer = new SimpleMessageListenerContainer(connectionFactory);
        listenerContainer.setQueues(queues);
        return new AmqpInboundChannelAdapterSMLCSpec(listenerContainer);
    }

    public static AmqpInboundChannelAdapterSMLCSpec inboundAdapter(SimpleMessageListenerContainer listenerContainer) {
        return new AmqpInboundChannelAdapterSMLCSpec(listenerContainer);
    }

    public static AmqpInboundChannelAdapterDMLCSpec inboundAdapter(DirectMessageListenerContainer listenerContainer) {
        return new AmqpInboundChannelAdapterDMLCSpec(listenerContainer);
    }

    public static AmqpOutboundEndpointSpec outboundAdapter(AmqpTemplate amqpTemplate) {
        return new AmqpOutboundEndpointSpec(amqpTemplate, false);
    }

    public static AmqpOutboundEndpointSpec outboundGateway(AmqpTemplate amqpTemplate) {
        return new AmqpOutboundEndpointSpec(amqpTemplate, true);
    }

    public static AmqpAsyncOutboundGatewaySpec asyncOutboundGateway(AsyncRabbitTemplate asyncRabbitTemplate) {
        return new AmqpAsyncOutboundGatewaySpec(asyncRabbitTemplate);
    }

    public static <S extends AmqpPollableMessageChannelSpec<S>> AmqpPollableMessageChannelSpec<S> pollableChannel(ConnectionFactory connectionFactory) {
        return Amqp.pollableChannel(null, connectionFactory);
    }

    public static <S extends AmqpPollableMessageChannelSpec<S>> AmqpPollableMessageChannelSpec<S> pollableChannel(String id, ConnectionFactory connectionFactory) {
        return new AmqpPollableMessageChannelSpec(connectionFactory).id(id);
    }

    public static <S extends AmqpMessageChannelSpec<S>> AmqpMessageChannelSpec<S> channel(ConnectionFactory connectionFactory) {
        return Amqp.channel(null, connectionFactory);
    }

    public static <S extends AmqpMessageChannelSpec<S>> AmqpMessageChannelSpec<S> channel(String id, ConnectionFactory connectionFactory) {
        return (AmqpMessageChannelSpec)new AmqpMessageChannelSpec(connectionFactory).id(id);
    }

    public static AmqpPublishSubscribeMessageChannelSpec publishSubscribeChannel(ConnectionFactory connectionFactory) {
        return Amqp.publishSubscribeChannel(null, connectionFactory);
    }

    public static AmqpPublishSubscribeMessageChannelSpec publishSubscribeChannel(String id, ConnectionFactory connectionFactory) {
        return (AmqpPublishSubscribeMessageChannelSpec)new AmqpPublishSubscribeMessageChannelSpec(connectionFactory).id(id);
    }

    private Amqp() {
    }
}

