/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.remote.session;

import java.io.InputStream;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.integration.file.remote.session.Session;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.util.Assert;

public class CachingSessionFactory
implements SessionFactory,
DisposableBean {
    private static Logger logger = Logger.getLogger(CachingSessionFactory.class.getName());
    public static final int DEFAULT_POOL_SIZE = 10;
    private final Queue<Session> queue;
    private final SessionFactory sessionFactory;
    private final int maxPoolSize;
    private final ReentrantLock lock = new ReentrantLock();

    public CachingSessionFactory(SessionFactory sessionFactory) {
        this(sessionFactory, 10);
    }

    public CachingSessionFactory(SessionFactory sessionFactory, int maxPoolSize) {
        this.sessionFactory = sessionFactory;
        this.maxPoolSize = maxPoolSize;
        this.queue = new ArrayBlockingQueue<Session>(this.maxPoolSize, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getSession() {
        Assert.notNull(this.queue, (String)"SftpSession is unavailable since the pool component is not started");
        this.lock.lock();
        try {
            Session session = this.queue.poll();
            if (null == session) {
                session = this.sessionFactory.getSession();
            }
            CachedSession cachedSession = session != null ? new CachedSession(session) : null;
            return cachedSession;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void destroy() {
        if (this.queue != null) {
            for (Session session : this.queue) {
                this.closeSession(session);
            }
        }
    }

    private void closeSession(Session session) {
        try {
            if (session != null) {
                session.close();
            }
        }
        catch (Throwable e) {
            logger.warning("Exception was thrown while destroying SftpSession. " + e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CachedSession
    implements Session {
        private final Session targetSession;

        private CachedSession(Session targetSession) {
            this.targetSession = targetSession;
        }

        @Override
        public void close() {
            if (CachingSessionFactory.this.queue.size() < CachingSessionFactory.this.maxPoolSize) {
                CachingSessionFactory.this.queue.add(this.targetSession);
            } else {
                this.targetSession.close();
            }
        }

        @Override
        public boolean rm(String path) {
            return this.targetSession.rm(path);
        }

        @Override
        public <F> F[] ls(String path) {
            return this.targetSession.ls(path);
        }

        @Override
        public InputStream get(String source) {
            return this.targetSession.get(source);
        }

        @Override
        public void put(InputStream inputStream, String destination) {
            this.targetSession.put(inputStream, destination);
        }
    }
}

