/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.locking;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

final class FileChannelCache {
    private static ConcurrentMap<File, FileChannel> channelCache = new ConcurrentHashMap<File, FileChannel>();

    FileChannelCache() {
    }

    public static FileLock tryLockFor(File fileToLock) throws IOException {
        FileChannel channel = (FileChannel)channelCache.get(fileToLock);
        if (channel == null) {
            FileChannel newChannel = new RandomAccessFile(fileToLock, "rw").getChannel();
            FileChannel original = channelCache.putIfAbsent(fileToLock, newChannel);
            channel = original != null ? original : newChannel;
        }
        FileLock lock = null;
        if (channel != null) {
            try {
                lock = channel.tryLock();
            }
            catch (OverlappingFileLockException overlappingFileLockException) {
                // empty catch block
            }
        }
        return lock;
    }

    public static void closeChannelFor(File fileToUnlock) {
        FileChannel fileChannel = (FileChannel)channelCache.remove(fileToUnlock);
        if (fileChannel != null) {
            try {
                fileChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static boolean isLocked(File file) {
        return channelCache.containsKey(file);
    }
}

