/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.remote.gateway;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.integration.Message;
import org.springframework.integration.MessagingException;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.remote.AbstractFileInfo;
import org.springframework.integration.file.remote.session.ExtendedSession;
import org.springframework.integration.file.remote.session.Session;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.handler.ExpressionEvaluatingMessageProcessor;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRemoteFileOutboundGateway<F>
extends AbstractReplyProducingMessageHandler {
    protected final SessionFactory<F> sessionFactory;
    protected final String command;
    public static final String COMMAND_LS = "ls";
    public static final String COMMAND_GET = "get";
    public static final String COMMAND_RM = "rm";
    public static final String COMMAND_MGET = "mget";
    public static final String OPTION_NAME_ONLY = "-1";
    public static final String OPTION_ALL = "-a";
    public static final String OPTION_NOSORT = "-f";
    public static final String OPTION_SUBDIRS = "-dirs";
    public static final String OPTION_LINKS = "-links";
    public static final String OPTION_PRESERVE_TIMESTAMP = "-P";
    public static final String OPTION_EXCEPTION_WHEN_EMPTY = "-x";
    private final Set<String> supportedCommands = new HashSet<String>(Arrays.asList("ls", "get", "rm", "mget"));
    private final ExpressionEvaluatingMessageProcessor<String> processor;
    protected volatile Set<String> options = new HashSet<String>();
    private volatile String remoteFileSeparator = "/";
    private volatile File localDirectory;
    private volatile boolean autoCreateLocalDirectory = true;
    private volatile String temporaryFileSuffix = ".writing";
    private volatile FileListFilter<F> filter;

    public AbstractRemoteFileOutboundGateway(SessionFactory<F> sessionFactory, String command, String expression) {
        this.sessionFactory = sessionFactory;
        this.command = command;
        this.processor = new ExpressionEvaluatingMessageProcessor(new SpelExpressionParser().parseExpression(expression));
    }

    public void setOptions(String options) {
        String[] opts;
        for (String opt : opts = options.split("\\s")) {
            this.options.add(opt.trim());
        }
    }

    public void setRemoteFileSeparator(String remoteFileSeparator) {
        this.remoteFileSeparator = remoteFileSeparator;
    }

    public void setLocalDirectory(File localDirectory) {
        this.localDirectory = localDirectory;
    }

    public void setAutoCreateLocalDirectory(boolean autoCreateLocalDirectory) {
        this.autoCreateLocalDirectory = autoCreateLocalDirectory;
    }

    public void setTemporaryFileSuffix(String temporaryFileSuffix) {
        this.temporaryFileSuffix = temporaryFileSuffix;
    }

    public void setFilter(FileListFilter<F> filter) {
        this.filter = filter;
    }

    protected void onInit() {
        block8: {
            super.onInit();
            Assert.notNull((Object)this.command, (String)"command must not be null");
            Assert.isTrue((boolean)this.supportedCommands.contains(this.command), (String)("command must be one of " + StringUtils.collectionToCommaDelimitedString(this.supportedCommands)));
            if (COMMAND_RM.equals(this.command) || COMMAND_MGET.equals(this.command)) {
                Assert.isNull(this.filter, (String)"Filters are not supported with the rm and mget commands");
            }
            if (COMMAND_GET.equals(this.command) || COMMAND_MGET.equals(this.command)) {
                Assert.notNull((Object)this.localDirectory, (String)"localDirectory must not be null");
                try {
                    if (this.localDirectory.exists()) break block8;
                    if (this.autoCreateLocalDirectory) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("The '" + this.localDirectory + "' directory doesn't exist; Will create."));
                        }
                        if (!this.localDirectory.mkdirs()) {
                            throw new IOException("Failed to make local directory: " + this.localDirectory);
                        }
                        break block8;
                    }
                    throw new FileNotFoundException(this.localDirectory.getName());
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new MessagingException("Failure during initialization of: " + this.getComponentType(), (Throwable)e);
                }
            }
        }
    }

    protected Object handleRequestMessage(Message<?> requestMessage) {
        Session<F> session = this.sessionFactory.getSession();
        try {
            if (COMMAND_LS.equals(this.command)) {
                String dir = (String)this.processor.processMessage(requestMessage);
                if (!dir.endsWith(this.remoteFileSeparator)) {
                    dir = dir + this.remoteFileSeparator;
                }
                List<?> payload = this.ls(session, dir);
                Message message = MessageBuilder.withPayload(payload).setHeader("file_remoteDirectory", (Object)dir).build();
                return message;
            }
            if (COMMAND_GET.equals(this.command)) {
                String remoteFilename;
                String remoteFilePath = (String)this.processor.processMessage(requestMessage);
                String remoteDir = remoteFilePath.substring(0, remoteFilePath.indexOf(remoteFilename = this.getRemoteFilename(remoteFilePath)));
                if (remoteDir.length() == 0) {
                    remoteDir = this.remoteFileSeparator;
                }
                File payload = this.get(session, remoteFilePath, remoteFilename, true);
                Message message = MessageBuilder.withPayload((Object)payload).setHeader("file_remoteDirectory", (Object)remoteDir).setHeader("file_remoteFile", (Object)remoteFilename).build();
                return message;
            }
            if (COMMAND_MGET.equals(this.command)) {
                String remoteFilename;
                String remoteFilePath = (String)this.processor.processMessage(requestMessage);
                String remoteDir = remoteFilePath.substring(0, remoteFilePath.indexOf(remoteFilename = this.getRemoteFilename(remoteFilePath)));
                if (remoteDir.length() == 0) {
                    remoteDir = this.remoteFileSeparator;
                }
                List<File> payload = this.mGet(session, remoteDir, remoteFilename);
                Message message = MessageBuilder.withPayload(payload).setHeader("file_remoteDirectory", (Object)remoteDir).setHeader("file_remoteFile", (Object)remoteFilename).build();
                return message;
            }
            if (COMMAND_RM.equals(this.command)) {
                String remoteFilename;
                String remoteFilePath = (String)this.processor.processMessage(requestMessage);
                String remoteDir = remoteFilePath.substring(0, remoteFilePath.indexOf(remoteFilename = this.getRemoteFilename(remoteFilePath)));
                if (remoteDir.length() == 0) {
                    remoteDir = this.remoteFileSeparator;
                }
                boolean payload = this.rm(session, remoteFilePath);
                Message message = MessageBuilder.withPayload((Object)payload).setHeader("file_remoteDirectory", (Object)remoteDir).setHeader("file_remoteFile", (Object)remoteFilename).build();
                return message;
            }
            Object remoteFilePath = null;
            return remoteFilePath;
        }
        catch (IOException e) {
            throw new MessagingException(requestMessage, (Throwable)e);
        }
        finally {
            session.close();
        }
    }

    protected List<?> ls(Session<F> session, String dir) throws IOException {
        ArrayList lsFiles = new ArrayList();
        Object[] files = session.list(dir);
        if (!ObjectUtils.isEmpty((Object[])files)) {
            List<Object> filteredFiles = this.filterFiles(files);
            for (Object e : filteredFiles) {
                if (e == null || !this.options.contains(OPTION_SUBDIRS) && this.isDirectory(e)) continue;
                lsFiles.add(e);
            }
        } else {
            return lsFiles;
        }
        if (!this.options.contains(OPTION_LINKS)) {
            this.purgeLinks(lsFiles);
        }
        if (!this.options.contains(OPTION_ALL)) {
            this.purgeDots(lsFiles);
        }
        if (this.options.contains(OPTION_NAME_ONLY)) {
            ArrayList<String> results = new ArrayList<String>();
            for (Object object : lsFiles) {
                results.add(this.getFilename(object));
            }
            if (!this.options.contains(OPTION_NOSORT)) {
                Collections.sort(results);
            }
            return results;
        }
        List canonicalFiles = this.asFileInfoList(lsFiles);
        for (AbstractFileInfo abstractFileInfo : canonicalFiles) {
            abstractFileInfo.setRemoteDirectory(dir);
        }
        if (!this.options.contains(OPTION_NOSORT)) {
            Collections.sort(canonicalFiles);
        }
        return canonicalFiles;
    }

    protected final List<F> filterFiles(F[] files) {
        return this.filter != null ? this.filter.filterFiles(files) : Arrays.asList(files);
    }

    protected void purgeLinks(List<F> lsFiles) {
        Iterator<F> iterator = lsFiles.iterator();
        while (iterator.hasNext()) {
            if (!this.isLink(iterator.next())) continue;
            iterator.remove();
        }
    }

    protected void purgeDots(List<F> lsFiles) {
        Iterator<F> iterator = lsFiles.iterator();
        while (iterator.hasNext()) {
            if (!this.getFilename(iterator.next()).startsWith(".")) continue;
            iterator.remove();
        }
    }

    protected File get(Session<F> session, String remoteFilePath, String remoteFilename, boolean lsFirst) throws IOException {
        F[] files = null;
        if (lsFirst && ((files = session.list(remoteFilePath)).length != 1 || this.isDirectory(files[0]) || this.isLink(files[0]))) {
            throw new MessagingException(remoteFilePath + " is not a file");
        }
        File localFile = new File(this.localDirectory, remoteFilename);
        if (!localFile.exists()) {
            String tempFileName = localFile.getAbsolutePath() + this.temporaryFileSuffix;
            File tempFile = new File(tempFileName);
            FileOutputStream fileOutputStream = new FileOutputStream(tempFile);
            try {
                session.read(remoteFilePath, fileOutputStream);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new MessagingException("Failure occurred while copying from remote to local directory", (Throwable)e);
            }
            finally {
                try {
                    fileOutputStream.close();
                }
                catch (Exception ignored2) {}
            }
            if (!tempFile.renameTo(localFile)) {
                throw new MessagingException("Failed to rename local file");
            }
            if (lsFirst && this.options.contains(OPTION_PRESERVE_TIMESTAMP)) {
                localFile.setLastModified(this.getModified(files[0]));
            }
            return localFile;
        }
        throw new MessagingException("Local file " + localFile + " already exists");
    }

    protected List<File> mGet(Session<F> session, String remoteDirectory, String remoteFilename) throws IOException {
        Assert.isInstanceOf(ExtendedSession.class, session, (String)"mget failed - ");
        String path = this.fixPath(remoteDirectory, remoteFilename);
        String[] fileNames = ((ExtendedSession)session).listNames(path);
        if (fileNames.length == 0 && this.options.contains(OPTION_EXCEPTION_WHEN_EMPTY)) {
            throw new MessagingException("No files found at " + remoteDirectory + " with pattern " + remoteFilename);
        }
        ArrayList<File> files = new ArrayList<File>();
        for (String fileName : fileNames) {
            files.add(this.get(session, this.fixPath(remoteDirectory, fileName), fileName, false));
        }
        return files;
    }

    private String fixPath(String remoteDirectory, String remoteFilename) {
        String path = this.remoteFileSeparator.equals(remoteDirectory) ? remoteFilename : (remoteDirectory.endsWith(this.remoteFileSeparator) ? remoteDirectory + remoteFilename : remoteDirectory + this.remoteFileSeparator + remoteFilename);
        return path;
    }

    protected String getRemoteFilename(String remoteFilePath) {
        int index = remoteFilePath.lastIndexOf(this.remoteFileSeparator);
        String remoteFileName = index < 0 ? remoteFilePath : remoteFilePath.substring(index + 1);
        return remoteFileName;
    }

    protected boolean rm(Session<?> session, String remoteFilePath) throws IOException {
        return session.remove(remoteFilePath);
    }

    protected abstract boolean isDirectory(F var1);

    protected abstract boolean isLink(F var1);

    protected abstract String getFilename(F var1);

    protected abstract long getModified(F var1);

    protected abstract List<AbstractFileInfo<F>> asFileInfoList(Collection<F> var1);
}

