/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.config;

import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractOutboundChannelAdapterParser;
import org.springframework.integration.file.config.FileWritingMessageHandlerBeanDefinitionBuilder;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class FileOutboundChannelAdapterParser
extends AbstractOutboundChannelAdapterParser {
    protected AbstractBeanDefinition parseConsumer(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder handlerBuilder = FileWritingMessageHandlerBeanDefinitionBuilder.configure(element, "nullChannel", parserContext);
        if (handlerBuilder != null) {
            String remoteFileNameGenerator = element.getAttribute("filename-generator");
            String remoteFileNameGeneratorExpression = element.getAttribute("filename-generator-expression");
            boolean hasRemoteFileNameGenerator = StringUtils.hasText((String)remoteFileNameGenerator);
            boolean hasRemoteFileNameGeneratorExpression = StringUtils.hasText((String)remoteFileNameGeneratorExpression);
            if (hasRemoteFileNameGenerator || hasRemoteFileNameGeneratorExpression) {
                if (hasRemoteFileNameGenerator && hasRemoteFileNameGeneratorExpression) {
                    parserContext.getReaderContext().error("at most one of 'filename-generator-expression' or 'filename-generator' is allowed on file outbound adapter/gateway", (Object)element);
                }
                if (hasRemoteFileNameGenerator) {
                    handlerBuilder.addPropertyReference("fileNameGenerator", remoteFileNameGenerator);
                } else {
                    BeanDefinitionBuilder fileNameGeneratorBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.file.DefaultFileNameGenerator");
                    fileNameGeneratorBuilder.addPropertyValue("expression", (Object)remoteFileNameGeneratorExpression);
                    handlerBuilder.addPropertyValue("fileNameGenerator", (Object)fileNameGeneratorBuilder.getBeanDefinition());
                }
            }
        }
        return handlerBuilder != null ? handlerBuilder.getBeanDefinition() : null;
    }
}

