/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.config;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.integration.file.filters.AcceptAllFileListFilter;
import org.springframework.integration.file.filters.AcceptOnceFileListFilter;
import org.springframework.integration.file.filters.CompositeFileListFilter;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.filters.IgnoreHiddenFileListFilter;
import org.springframework.integration.file.filters.RegexPatternFileListFilter;
import org.springframework.integration.file.filters.SimplePatternFileListFilter;
import org.springframework.lang.NonNull;

public class FileListFilterFactoryBean
implements FactoryBean<FileListFilter<File>> {
    private volatile FileListFilter<File> result;
    private volatile FileListFilter<File> filter;
    private volatile String filenamePattern;
    private volatile String filenameRegex;
    private volatile Boolean ignoreHidden = Boolean.TRUE;
    private volatile Boolean preventDuplicates;
    private volatile Boolean alwaysAcceptDirectories;
    private final Lock monitor = new ReentrantLock();

    public void setFilter(FileListFilter<File> filter) {
        this.filter = filter;
    }

    public void setFilenamePattern(String filenamePattern) {
        this.filenamePattern = filenamePattern;
    }

    public void setFilenameRegex(String filenameRegex) {
        this.filenameRegex = filenameRegex;
    }

    public void setIgnoreHidden(Boolean ignoreHidden) {
        this.ignoreHidden = ignoreHidden;
    }

    public void setPreventDuplicates(Boolean preventDuplicates) {
        this.preventDuplicates = preventDuplicates;
    }

    public void setAlwaysAcceptDirectories(Boolean alwaysAcceptDirectories) {
        this.alwaysAcceptDirectories = alwaysAcceptDirectories;
    }

    @NonNull
    public FileListFilter<File> getObject() {
        if (this.result == null) {
            this.monitor.lock();
            try {
                this.initializeFileListFilter();
            }
            finally {
                this.monitor.unlock();
            }
        }
        return this.result;
    }

    public Class<?> getObjectType() {
        return this.result != null ? this.result.getClass() : FileListFilter.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private void initializeFileListFilter() {
        if (this.result != null) {
            return;
        }
        CompositeFileListFilter<File> createdFilter = null;
        this.validate();
        ArrayList<FileListFilter<File>> filtersNeeded = new ArrayList<FileListFilter<File>>();
        if (!Boolean.FALSE.equals(this.ignoreHidden)) {
            filtersNeeded.add(new IgnoreHiddenFileListFilter());
        }
        if (this.filter != null) {
            this.filter(filtersNeeded);
        } else if (this.filenamePattern != null || this.filenameRegex != null) {
            this.pattern(filtersNeeded);
        } else if (Boolean.FALSE.equals(this.preventDuplicates)) {
            filtersNeeded.add(new AcceptAllFileListFilter());
        } else {
            filtersNeeded.add(new AcceptOnceFileListFilter());
        }
        createdFilter = filtersNeeded.size() == 1 ? (CompositeFileListFilter<File>)filtersNeeded.get(0) : new CompositeFileListFilter<File>(filtersNeeded);
        this.result = createdFilter;
    }

    private void validate() {
        if (this.filter != null && (this.filenamePattern != null || this.filenameRegex != null)) {
            throw new IllegalArgumentException("The 'filter' reference is mutually exclusive with either the 'filename-pattern' or 'filename-regex' attribute.");
        }
        if (this.filenamePattern != null && this.filenameRegex != null) {
            throw new IllegalArgumentException("The 'filename-pattern' and 'filename-regex' attributes are mutually exclusive.");
        }
    }

    private void filter(List<FileListFilter<File>> filtersNeeded) {
        if (Boolean.TRUE.equals(this.preventDuplicates)) {
            filtersNeeded.add(new AcceptOnceFileListFilter());
            filtersNeeded.add(this.filter);
        } else {
            filtersNeeded.add(this.filter);
        }
    }

    private void pattern(List<FileListFilter<File>> filtersNeeded) {
        if (!Boolean.FALSE.equals(this.preventDuplicates)) {
            filtersNeeded.add(new AcceptOnceFileListFilter());
        }
        if (this.filenamePattern != null) {
            SimplePatternFileListFilter patternFilter = new SimplePatternFileListFilter(this.filenamePattern);
            if (this.alwaysAcceptDirectories != null) {
                patternFilter.setAlwaysAcceptDirectories(this.alwaysAcceptDirectories);
            }
            filtersNeeded.add(patternFilter);
        }
        if (this.filenameRegex != null) {
            RegexPatternFileListFilter regexFilter = new RegexPatternFileListFilter(this.filenameRegex);
            if (this.alwaysAcceptDirectories != null) {
                regexFilter.setAlwaysAcceptDirectories(this.alwaysAcceptDirectories);
            }
            filtersNeeded.add(regexFilter);
        }
    }
}

