/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.filters;

import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.integration.file.filters.AbstractFileListFilter;
import org.springframework.integration.file.filters.ResettableFileListFilter;
import org.springframework.integration.file.filters.ReversibleFileListFilter;
import org.springframework.lang.Nullable;

public class AcceptOnceFileListFilter<F>
extends AbstractFileListFilter<F>
implements ReversibleFileListFilter<F>,
ResettableFileListFilter<F> {
    @Nullable
    private final Queue<F> seen;
    private final Set<F> seenSet = new HashSet<F>();
    private final Lock monitor = new ReentrantLock();

    public AcceptOnceFileListFilter(int maxCapacity) {
        this.seen = new LinkedBlockingQueue<F>(maxCapacity);
    }

    public AcceptOnceFileListFilter() {
        this.seen = null;
    }

    @Override
    public boolean accept(F file) {
        this.monitor.lock();
        try {
            if (this.seenSet.contains(file)) {
                boolean bl = false;
                return bl;
            }
            if (this.seen != null && !this.seen.offer(file)) {
                F removed = this.seen.poll();
                this.seenSet.remove(removed);
                this.seen.add(file);
            }
            this.seenSet.add(file);
            boolean bl = true;
            return bl;
        }
        finally {
            this.monitor.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(F file, List<F> files) {
        this.monitor.lock();
        try {
            boolean rollingBack = false;
            for (F fileToRollback : files) {
                if (fileToRollback.equals(file)) {
                    rollingBack = true;
                }
                if (!rollingBack) continue;
                this.remove(fileToRollback);
            }
        }
        finally {
            this.monitor.unlock();
        }
    }

    @Override
    public boolean remove(F fileToRemove) {
        boolean removed = this.seenSet.remove(fileToRemove);
        if (this.seen != null) {
            this.seen.remove(fileToRemove);
        }
        return removed;
    }
}

