/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.remote.aop;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.endpoint.AbstractFetchLimitingMessageSource;
import org.springframework.integration.file.remote.AbstractRemoteFileStreamingMessageSource;
import org.springframework.integration.file.remote.aop.RotationPolicy;
import org.springframework.integration.file.remote.session.DelegatingSessionFactory;
import org.springframework.integration.file.remote.synchronizer.AbstractInboundFileSynchronizingMessageSource;
import org.springframework.util.Assert;

public class StandardRotationPolicy
implements RotationPolicy {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final DelegatingSessionFactory<?> factory;
    private final List<RotationPolicy.KeyDirectory> keyDirectories = new ArrayList<RotationPolicy.KeyDirectory>();
    private final boolean fair;
    private volatile Iterator<RotationPolicy.KeyDirectory> iterator;
    private volatile RotationPolicy.KeyDirectory current;
    private volatile boolean initialized;

    public StandardRotationPolicy(DelegatingSessionFactory<?> factory, List<RotationPolicy.KeyDirectory> keyDirectories, boolean fair) {
        Assert.notNull(factory, (String)"factory cannot be null");
        Assert.notNull(keyDirectories, (String)"keyDirectories cannot be null");
        Assert.isTrue((!keyDirectories.isEmpty() ? 1 : 0) != 0, (String)"At least one KeyDirectory is required");
        this.factory = factory;
        this.keyDirectories.addAll(keyDirectories);
        this.fair = fair;
        this.iterator = this.keyDirectories.iterator();
    }

    @Override
    public void beforeReceive(MessageSource<?> source) {
        if (this.fair || !this.initialized) {
            this.configureSource(source);
            if (this.fair && !this.initialized && source instanceof AbstractFetchLimitingMessageSource) {
                AbstractFetchLimitingMessageSource fetchLimitingMessageSource = (AbstractFetchLimitingMessageSource)source;
                this.logger.info((Object)LogMessage.format((String)"Enforce 'maxFetchSize = 1' for '%s' in the 'fair' mode", source));
                fetchLimitingMessageSource.setMaxFetchSize(1);
            }
            this.initialized = true;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Next poll is for " + String.valueOf(this.current)));
        }
        this.factory.setThreadKey(this.current.getKey());
    }

    @Override
    public void afterReceive(boolean messageReceived, MessageSource<?> source) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Poll produced " + (messageReceived ? "a" : "no") + " message"));
        }
        this.factory.clearThreadKey();
        if (!this.fair && !messageReceived) {
            this.configureSource(source);
        }
    }

    @Override
    public RotationPolicy.KeyDirectory getCurrent() {
        return this.current;
    }

    protected DelegatingSessionFactory<?> getFactory() {
        return this.factory;
    }

    protected List<RotationPolicy.KeyDirectory> getKeyDirectories() {
        return Collections.unmodifiableList(this.keyDirectories);
    }

    protected boolean isFair() {
        return this.fair;
    }

    protected Iterator<RotationPolicy.KeyDirectory> getIterator() {
        return this.iterator;
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    protected void configureSource(MessageSource<?> source) {
        if (!this.iterator.hasNext()) {
            this.iterator = this.keyDirectories.iterator();
        }
        this.current = this.iterator.next();
        this.onRotation(source);
    }

    protected void onRotation(MessageSource<?> source) {
        if (source instanceof AbstractRemoteFileStreamingMessageSource) {
            AbstractRemoteFileStreamingMessageSource streamingMessageSource = (AbstractRemoteFileStreamingMessageSource)source;
            streamingMessageSource.setRemoteDirectory(this.current.getDirectory());
        } else if (source instanceof AbstractInboundFileSynchronizingMessageSource) {
            AbstractInboundFileSynchronizingMessageSource synchronizingMessageSource = (AbstractInboundFileSynchronizingMessageSource)source;
            synchronizingMessageSource.getSynchronizer().setRemoteDirectory(this.current.getDirectory());
        }
    }
}

