/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.flow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.flow.FlowConfiguration;
import org.springframework.integration.flow.PortConfiguration;
import org.springframework.integration.flow.config.FlowUtils;
import org.springframework.integration.flow.interceptor.FlowInterceptor;
import org.springframework.integration.support.channel.BeanFactoryChannelResolver;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.core.DestinationResolver;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class Flow
implements InitializingBean,
BeanNameAware,
DestinationResolver<MessageChannel>,
ApplicationContextAware {
    private static Log logger = LogFactory.getLog(Flow.class);
    private volatile ClassPathXmlApplicationContext flowContext;
    private ApplicationContext applicationContext;
    private volatile FlowConfiguration flowConfiguration;
    private volatile String[] configLocations;
    private volatile String[] referencedBeanLocations;
    private volatile Properties flowProperties;
    private volatile String beanName;
    private volatile String flowId;
    private volatile BeanFactoryChannelResolver flowChannelResolver;
    private volatile SubscribableChannel flowOutputChannel;
    private volatile boolean help;

    public Flow() {
    }

    public Flow(Properties flowProperties, String[] configLocations) {
        this.flowProperties = flowProperties;
        this.configLocations = configLocations;
    }

    public Flow(String[] configLocations) {
        this.configLocations = configLocations;
    }

    public void afterPropertiesSet() {
        if (this.flowId == null) {
            this.flowId = this.beanName;
        }
        if (this.help) {
            System.out.println(FlowUtils.getDocumentation(this.flowId));
        }
        if (this.configLocations == null) {
            this.configLocations = new String[]{String.format("classpath:META-INF/spring/integration/flows/%s/*.xml", this.flowId)};
        }
        if (this.referencedBeanLocations != null) {
            this.configLocations = (String[])ArrayUtils.addAll((Object[])this.configLocations, (Object[])this.referencedBeanLocations);
        }
        Assert.notEmpty((Object[])this.configLocations, (String)"configLocations cannot be empty");
        this.flowContext = new ClassPathXmlApplicationContext(this.applicationContext);
        this.addReferencedProperties();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("instantiating flow context from configLocations [" + StringUtils.arrayToCommaDelimitedString((Object[])this.configLocations) + "]"));
        }
        this.flowContext.setConfigLocations(this.configLocations);
        this.flowContext.refresh();
        this.flowConfiguration = (FlowConfiguration)this.flowContext.getBean(FlowConfiguration.class);
        Assert.notNull((Object)this.flowConfiguration, (String)"flow context does not contain a flow configuration");
        this.validatePortMapping();
        this.flowChannelResolver = new BeanFactoryChannelResolver((BeanFactory)this.flowContext);
        this.bridgeMessagingPorts();
    }

    public FlowConfiguration getFlowConfiguration() {
        return this.flowConfiguration;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setFlowId(String flowId) {
        this.flowId = flowId;
    }

    public void setReferencedBeanLocations(String[] referencedBeanLocations) {
        this.referencedBeanLocations = referencedBeanLocations;
    }

    public void setProperties(Properties flowProperties) {
        this.flowProperties = flowProperties;
    }

    public Properties getProperties() {
        return this.flowProperties;
    }

    public void setHelp(boolean help) {
        this.help = help;
    }

    public SubscribableChannel getFlowOutputChannel() {
        return this.flowOutputChannel;
    }

    public void setFlowOutputChannel(SubscribableChannel flowOutputChannel) {
        this.flowOutputChannel = flowOutputChannel;
    }

    public MessageChannel resolveDestination(String channelName) {
        return this.flowChannelResolver.resolveDestination(channelName);
    }

    private void addReferencedProperties() {
        if (this.flowProperties != null) {
            PropertyPlaceholderConfigurer ppc = new PropertyPlaceholderConfigurer();
            ppc.setProperties(this.flowProperties);
            this.flowContext.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)ppc);
        }
    }

    private void validatePortMapping() {
        Assert.notEmpty(this.flowConfiguration.getPortConfigurations(), (String)"flow configuration contains no port configurations");
        ArrayList<String> errors = new ArrayList<String>();
        List<String> channelNames = Arrays.asList(this.flowContext.getBeanNamesForType(MessageChannel.class));
        Set<String> referencedMessageChannels = FlowUtils.getReferencedMessageChannels(this.flowContext.getBeanFactory());
        for (String referencedMessageChannel : referencedMessageChannels) {
            if (channelNames.contains(referencedMessageChannel)) continue;
            errors.add("Flow references channel [" + referencedMessageChannel + "] defined in the parent context. " + "This channel should be explicitly defined in the flow context");
        }
        if (errors.size() > 0) {
            throw new BeanDefinitionValidationException("\n" + StringUtils.arrayToDelimitedString((Object[])errors.toArray(), (String)"\n"));
        }
    }

    private void bridgeMessagingPorts() {
        for (PortConfiguration targetPortConfiguration : this.getFlowConfiguration().getPortConfigurations()) {
            for (String outputPort : targetPortConfiguration.getOutputPortNames()) {
                String targetOutputChannelName = (String)targetPortConfiguration.getOutputChannel(outputPort);
                SubscribableChannel inputChannel = (SubscribableChannel)this.resolveDestination(targetOutputChannelName);
                ((AbstractMessageChannel)inputChannel).addInterceptor((ChannelInterceptor)new FlowInterceptor(outputPort));
                logger.debug((Object)("creating output bridge on [" + outputPort + "] inputChannelName = [" + targetOutputChannelName + "] outputChannel = [" + this.flowOutputChannel + "]"));
                FlowUtils.bridgeChannels(inputChannel, (MessageChannel)this.flowOutputChannel);
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getFlowContext() {
        return this.flowContext;
    }
}

