/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.flow.config;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.config.AbstractSimpleMessageHandlerFactoryBean;
import org.springframework.integration.flow.Flow;
import org.springframework.integration.flow.PortConfiguration;
import org.springframework.integration.flow.handler.FlowMessageHandler;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.Assert;

public class FlowMessageHandlerFactoryBean
extends AbstractSimpleMessageHandlerFactoryBean<FlowMessageHandler>
implements InitializingBean {
    private static Log logger = LogFactory.getLog(FlowMessageHandlerFactoryBean.class);
    private volatile Flow flow;
    private volatile String inputPortName;
    private volatile MessageChannel errorChannel;
    private volatile long timeout;
    private volatile PortConfiguration flowConfiguration;

    protected FlowMessageHandler createHandler() {
        MessageChannel flowInputChannel = this.flow.resolveDestination((String)this.flowConfiguration.getInputChannel());
        FlowMessageHandler flowMessageHandler = new FlowMessageHandler(flowInputChannel, this.flow.getFlowOutputChannel(), this.timeout);
        flowMessageHandler.setErrorChannel(this.errorChannel);
        return flowMessageHandler;
    }

    public void setFlow(Flow flow) {
        this.flow = flow;
    }

    public void setInputPortName(String inputPortName) {
        this.inputPortName = inputPortName;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setErrorChannel(MessageChannel errorChannel) {
        this.errorChannel = errorChannel;
    }

    public void afterPropertiesSet() throws Exception {
        this.flowConfiguration = null;
        if (this.inputPortName == null) {
            Assert.isTrue((this.flow.getFlowConfiguration().getPortConfigurations().size() <= 1 ? 1 : 0) != 0, (String)("flow [" + this.flow.getBeanName() + "] exposes multiple port configurations. Must specify an input port"));
            this.flowConfiguration = this.flow.getFlowConfiguration().getPortConfigurations().get(0);
            this.inputPortName = this.flowConfiguration.getInputPortName();
        } else {
            this.flowConfiguration = this.flow.getFlowConfiguration().getConfigurationForInputPort(this.inputPortName);
        }
    }
}

