/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.flow.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.integration.handler.BridgeHandler;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.util.ResourceUtils;

public class FlowUtils {
    private FlowUtils() {
    }

    public static void bridgeChannels(SubscribableChannel inputChannel, MessageChannel outputChannel) {
        BridgeHandler bridgeHandler = new BridgeHandler();
        bridgeHandler.setOutputChannel(outputChannel);
        inputChannel.subscribe((MessageHandler)bridgeHandler);
    }

    public static String registerBeanDefinition(BeanDefinition beanDefinition, BeanDefinitionRegistry registry) {
        String beanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)beanDefinition, (BeanDefinitionRegistry)registry);
        beanName = "flow." + beanName;
        String strIndex = StringUtils.substringAfter((String)beanName, (String)"#");
        int index = Integer.valueOf(strIndex);
        while (registry.isBeanNameInUse(beanName)) {
            beanName = beanName.replaceAll("#\\d$", "#" + ++index);
        }
        registry.registerBeanDefinition(beanName, beanDefinition);
        return beanName;
    }

    public static String getDocumentation(String flowId) {
        String path = String.format("classpath:META-INF/spring/integration/flows/%s/flow.doc", flowId);
        try {
            String line;
            File file = ResourceUtils.getFile((String)path);
            BufferedReader br = new BufferedReader(new FileReader(file));
            StringBuilder result = new StringBuilder();
            while ((line = br.readLine()) != null) {
                result.append(line).append("\n");
            }
            br.close();
            return result.toString();
        }
        catch (FileNotFoundException e) {
            return "no help available";
        }
        catch (IOException e) {
            e.printStackTrace();
            return "no help available";
        }
    }

    public static void displayBeansGraph(ConfigurableListableBeanFactory beanFactory) {
        String[] beans = beanFactory.getBeanNamesForType(Object.class);
        FlowUtils._displayDependencies(beanFactory, beans, 0);
    }

    private static void _displayDependencies(ConfigurableListableBeanFactory beanFactory, String[] beans, int level) {
        for (String bean : beans) {
            System.out.println(FlowUtils.indent(level) + bean);
            String[] dependencies = beanFactory.getDependenciesForBean(bean);
            String[] depsArray = new String[dependencies.length];
            int index = 0;
            for (String dependency : dependencies) {
                if (!dependency.equals(bean)) {
                    depsArray[index++] = dependency;
                    continue;
                }
                System.out.println(FlowUtils.indent(level + 1) + bean);
            }
            if (depsArray.length <= 0) continue;
            FlowUtils._displayDependencies(beanFactory, Arrays.copyOf(depsArray, index), level + 1);
        }
    }

    public static Set<String> getReferencedMessageChannels(ConfigurableListableBeanFactory beanFactory) {
        String[] beans = beanFactory.getBeanNamesForType(Object.class);
        HashSet<String> messageChannels = new HashSet<String>();
        FlowUtils._getReferencedMessageChannels(beanFactory, beans, messageChannels);
        return Collections.unmodifiableSet(messageChannels);
    }

    private static void _getReferencedMessageChannels(ConfigurableListableBeanFactory beanFactory, String[] beans, Set<String> messageChannels) {
        for (String bean : beans) {
            String[] dependencies;
            if (bean.startsWith("(inner bean)") || bean.equals("nullChannel")) continue;
            Class clazz = null;
            if (beanFactory.containsBean(bean)) {
                clazz = beanFactory.getType(bean);
            }
            if (clazz == null) continue;
            if (MessageChannel.class.isAssignableFrom(clazz)) {
                messageChannels.add(bean);
            }
            if ((dependencies = beanFactory.getDependenciesForBean(bean)).length <= 0) continue;
            FlowUtils._getReferencedMessageChannels(beanFactory, dependencies, messageChannels);
        }
    }

    private static String indent(int size) {
        String indent = "";
        for (int i = 0; i < size; ++i) {
            indent = indent + "  ";
        }
        return indent;
    }
}

