/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.gemfire.metadata;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.util.CacheListenerAdapter;
import org.springframework.integration.metadata.ListenableMetadataStore;
import org.springframework.integration.metadata.MetadataStoreListener;
import org.springframework.util.Assert;

public class GemfireMetadataStore
implements ListenableMetadataStore {
    private static final String KEY_MUST_NOT_BE_NULL = "'key' must not be null.";
    public static final String KEY = "MetaData";
    private final GemfireCacheListener cacheListener = new GemfireCacheListener();
    private final Region<String, String> region;

    public GemfireMetadataStore(Cache cache) {
        this((Region<String, String>)Objects.requireNonNull(cache, "'cache' must not be null").createRegionFactory().setScope(Scope.LOCAL).create(KEY));
    }

    public GemfireMetadataStore(Region<String, String> region) {
        Assert.notNull(region, (String)"'region' must not be null");
        this.region = region;
        this.region.getAttributesMutator().addCacheListener((CacheListener)this.cacheListener);
    }

    public void put(String key, String value) {
        Assert.notNull((Object)key, (String)KEY_MUST_NOT_BE_NULL);
        Assert.notNull((Object)value, (String)"'value' must not be null.");
        this.region.put((Object)key, (Object)value);
    }

    public String putIfAbsent(String key, String value) {
        Assert.notNull((Object)key, (String)KEY_MUST_NOT_BE_NULL);
        Assert.notNull((Object)value, (String)"'value' must not be null.");
        return (String)this.region.putIfAbsent((Object)key, (Object)value);
    }

    public boolean replace(String key, String oldValue, String newValue) {
        Assert.notNull((Object)key, (String)KEY_MUST_NOT_BE_NULL);
        Assert.notNull((Object)oldValue, (String)"'oldValue' must not be null.");
        Assert.notNull((Object)newValue, (String)"'newValue' must not be null.");
        return this.region.replace((Object)key, (Object)oldValue, (Object)newValue);
    }

    public String get(String key) {
        Assert.notNull((Object)key, (String)KEY_MUST_NOT_BE_NULL);
        return (String)this.region.get((Object)key);
    }

    public String remove(String key) {
        Assert.notNull((Object)key, (String)KEY_MUST_NOT_BE_NULL);
        return (String)this.region.remove((Object)key);
    }

    public void addListener(MetadataStoreListener listener) {
        Assert.notNull((Object)listener, (String)"'listener' must not be null");
        this.cacheListener.listeners.add(listener);
    }

    public void removeListener(MetadataStoreListener listener) {
        this.cacheListener.listeners.remove(listener);
    }

    private static class GemfireCacheListener
    extends CacheListenerAdapter<String, String> {
        private final List<MetadataStoreListener> listeners = new CopyOnWriteArrayList<MetadataStoreListener>();

        GemfireCacheListener() {
        }

        public void afterCreate(EntryEvent<String, String> event) {
            this.listeners.forEach(listener -> listener.onAdd((String)event.getKey(), (String)event.getNewValue()));
        }

        public void afterUpdate(EntryEvent<String, String> event) {
            this.listeners.forEach(listener -> listener.onUpdate((String)event.getKey(), (String)event.getNewValue()));
        }

        public void afterDestroy(EntryEvent<String, String> event) {
            this.listeners.forEach(listener -> listener.onRemove((String)event.getKey(), (String)event.getOldValue()));
        }
    }
}

