/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.hazelcast.listener;

import com.hazelcast.cluster.MembershipAdapter;
import com.hazelcast.cluster.MembershipEvent;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.cp.lock.FencedLock;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.multimap.MultiMap;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Set;

public class HazelcastMembershipListener
extends MembershipAdapter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void memberRemoved(MembershipEvent membershipEvent) {
        InetSocketAddress removedMemberSocketAddress = membershipEvent.getMember().getSocketAddress(EndpointQualifier.MEMBER);
        Set hazelcastLocalInstanceSet = Hazelcast.getAllHazelcastInstances();
        if (!hazelcastLocalInstanceSet.isEmpty()) {
            HazelcastInstance hazelcastInstance = (HazelcastInstance)hazelcastLocalInstanceSet.iterator().next();
            FencedLock lock = hazelcastInstance.getCPSubsystem().getLock("SPRING_INTEGRATION_INTERNAL_CLUSTER_LOCK");
            lock.lock();
            try {
                MultiMap configMultiMap = hazelcastInstance.getMultiMap("SPRING_INTEGRATION_INTERNAL_CLUSTER_MULTIMAP");
                if (configMultiMap.containsKey((Object)removedMemberSocketAddress)) {
                    SocketAddress newAdminSocketAddress = this.getNewAdminInstanceSocketAddress((MultiMap<SocketAddress, SocketAddress>)configMultiMap, removedMemberSocketAddress);
                    for (SocketAddress socketAddress : configMultiMap.values()) {
                        if (socketAddress.equals(removedMemberSocketAddress)) continue;
                        configMultiMap.put((Object)newAdminSocketAddress, (Object)socketAddress);
                    }
                    configMultiMap.remove((Object)removedMemberSocketAddress);
                } else {
                    configMultiMap.remove(configMultiMap.keySet().iterator().next(), (Object)removedMemberSocketAddress);
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    private SocketAddress getNewAdminInstanceSocketAddress(MultiMap<SocketAddress, SocketAddress> configMultiMap, SocketAddress removedMemberSocketAddress) {
        for (SocketAddress socketAddress : configMultiMap.values()) {
            if (socketAddress.equals(removedMemberSocketAddress)) continue;
            return socketAddress;
        }
        throw new IllegalStateException("No Active Hazelcast Instance Found.");
    }
}

