/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.config;

import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractOutboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.http.config.HttpAdapterParsingUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class HttpOutboundChannelAdapterParser
extends AbstractOutboundChannelAdapterParser {
    protected AbstractBeanDefinition parseConsumer(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.http.outbound.HttpRequestExecutingMessageHandler");
        builder.addPropertyValue("expectReply", (Object)false);
        builder.addConstructorArgValue((Object)element.getAttribute("url"));
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"http-method");
        String restTemplate = element.getAttribute("rest-template");
        if (StringUtils.hasText((String)restTemplate)) {
            HttpAdapterParsingUtils.verifyNoRestTemplateAttributes(element, parserContext);
            builder.addConstructorArgReference(restTemplate);
        } else {
            for (String referenceAttributeName : HttpAdapterParsingUtils.REST_TEMPLATE_REFERENCE_ATTRIBUTES) {
                IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)referenceAttributeName);
            }
        }
        String headerMapper = element.getAttribute("header-mapper");
        String mappedRequestHeaders = element.getAttribute("mapped-request-headers");
        if (StringUtils.hasText((String)headerMapper)) {
            if (StringUtils.hasText((String)mappedRequestHeaders)) {
                parserContext.getReaderContext().error("The 'mappped-request-headers' attribute is not allowed when a 'header-mapper' has been specified.", parserContext.extractSource((Object)element));
                return null;
            }
            builder.addPropertyReference("headerMapper", headerMapper);
        } else if (StringUtils.hasText((String)mappedRequestHeaders)) {
            BeanDefinitionBuilder headerMapperBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.http.support.DefaultHttpHeaderMapper");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)headerMapperBuilder, (Element)element, (String)"mapped-request-headers", (String)"outboundHeaderNames");
            builder.addPropertyValue("headerMapper", (Object)headerMapperBuilder.getBeanDefinition());
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"charset");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"extract-payload");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"expected-response-type");
        HttpAdapterParsingUtils.configureUriVariableExpressions(builder, element);
        return builder.getBeanDefinition();
    }
}

