/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.config;

import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.config.ExpressionFactoryBean;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

abstract class HttpAdapterParsingUtils {
    static final String[] REST_TEMPLATE_REFERENCE_ATTRIBUTES = new String[]{"request-factory", "error-handler", "message-converters"};

    HttpAdapterParsingUtils() {
    }

    static void verifyNoRestTemplateAttributes(Element element, ParserContext parserContext) {
        for (String attributeName : REST_TEMPLATE_REFERENCE_ATTRIBUTES) {
            if (!element.hasAttribute(attributeName)) continue;
            parserContext.getReaderContext().error("When providing a 'rest-template' reference, the '" + attributeName + "' attribute is not allowed.", parserContext.extractSource((Object)element));
        }
    }

    static void configureUriVariableExpressions(BeanDefinitionBuilder builder, Element element) {
        List uriVariableElements = DomUtils.getChildElementsByTagName((Element)element, (String)"uri-variable");
        if (!CollectionUtils.isEmpty((Collection)uriVariableElements)) {
            ManagedMap uriVariableExpressions = new ManagedMap();
            for (Element uriVariableElement : uriVariableElements) {
                String name = uriVariableElement.getAttribute("name");
                String expression = uriVariableElement.getAttribute("expression");
                BeanDefinitionBuilder factoryBeanBuilder = BeanDefinitionBuilder.genericBeanDefinition(ExpressionFactoryBean.class);
                factoryBeanBuilder.addConstructorArgValue((Object)expression);
                uriVariableExpressions.put((Object)name, (Object)factoryBeanBuilder.getBeanDefinition());
            }
            builder.addPropertyValue("uriVariableExpressions", (Object)uriVariableExpressions);
        }
    }

    static void configureUrlConstructorArg(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        RootBeanDefinition expressionDef;
        boolean hasUrlExpressionAttribute;
        String urlAttribute = element.getAttribute("url");
        String urlExpressionAttribute = element.getAttribute("url-expression");
        boolean hasUrlAttribute = StringUtils.hasText((String)urlAttribute);
        if (!(hasUrlAttribute ^ (hasUrlExpressionAttribute = StringUtils.hasText((String)urlExpressionAttribute)))) {
            parserContext.getReaderContext().error("Adapter must have exactly one of 'url' or 'url-expression'", (Object)element);
        }
        if (hasUrlAttribute) {
            expressionDef = new RootBeanDefinition(LiteralExpression.class);
            expressionDef.getConstructorArgumentValues().addGenericArgumentValue((Object)urlAttribute);
        } else {
            expressionDef = new RootBeanDefinition(ExpressionFactoryBean.class);
            expressionDef.getConstructorArgumentValues().addGenericArgumentValue((Object)urlExpressionAttribute);
        }
        builder.addConstructorArgValue((Object)expressionDef);
    }

    static void setHttpMethodOrExpression(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String httpMethod = element.getAttribute("http-method");
        String httpMethodExpression = element.getAttribute("http-method-expression");
        boolean hasHttpMethod = StringUtils.hasText((String)httpMethod);
        boolean hasHttpMethodExpression = StringUtils.hasText((String)httpMethodExpression);
        if (hasHttpMethod && hasHttpMethodExpression) {
            parserContext.getReaderContext().error("The 'http-method' and 'http-method-expression' are mutually exclusive. You can only have one or the other", (Object)element);
        }
        RootBeanDefinition expressionDef = null;
        if (hasHttpMethod) {
            expressionDef = new RootBeanDefinition(LiteralExpression.class);
            expressionDef.getConstructorArgumentValues().addGenericArgumentValue((Object)httpMethod);
        } else if (hasHttpMethodExpression) {
            expressionDef = new RootBeanDefinition(ExpressionFactoryBean.class);
            expressionDef.getConstructorArgumentValues().addGenericArgumentValue((Object)httpMethodExpression);
        }
        if (expressionDef != null) {
            builder.addPropertyValue("httpMethodExpression", (Object)expressionDef);
        }
    }

    static void setExpectedResponseOrExpression(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String expectedResponseType = element.getAttribute("expected-response-type");
        String expectedResponseTypeExpression = element.getAttribute("expected-response-type-expression");
        boolean hasExpectedResponseType = StringUtils.hasText((String)expectedResponseType);
        boolean hasExpectedResponseTypeExpression = StringUtils.hasText((String)expectedResponseTypeExpression);
        if (hasExpectedResponseType && hasExpectedResponseTypeExpression) {
            parserContext.getReaderContext().error("The 'expected-response-type' and 'expected-response-type-expression' are mutually exclusive. You can only have one or the other", (Object)element);
        }
        RootBeanDefinition expressionDef = null;
        if (hasExpectedResponseType) {
            expressionDef = new RootBeanDefinition(LiteralExpression.class);
            expressionDef.getConstructorArgumentValues().addGenericArgumentValue((Object)expectedResponseType);
        } else if (hasExpectedResponseTypeExpression) {
            expressionDef = new RootBeanDefinition(ExpressionFactoryBean.class);
            expressionDef.getConstructorArgumentValues().addGenericArgumentValue((Object)expectedResponseTypeExpression);
        }
        if (expressionDef != null) {
            builder.addPropertyValue("expectedResponseTypeExpression", (Object)expressionDef);
        }
    }
}

