/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.inbound;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.integration.http.inbound.HttpRequestHandlingEndpointSupport;
import org.springframework.integration.http.inbound.RequestMapping;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.mvc.condition.RequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public final class IntegrationRequestMappingHandlerMapping
extends RequestMappingHandlerMapping {
    private static final Method HANDLE_REQUEST_METHOD = ReflectionUtils.findMethod(HttpRequestHandler.class, (String)"handleRequest", (Class[])new Class[]{HttpServletRequest.class, HttpServletResponse.class});
    private static final Method CREATE_REQUEST_MAPPING_INFO_METHOD = ReflectionUtils.findMethod(RequestMappingHandlerMapping.class, (String)"createRequestMappingInfo", (Class[])new Class[]{org.springframework.web.bind.annotation.RequestMapping.class, RequestCondition.class});

    protected final boolean isHandler(Class<?> beanType) {
        return HttpRequestHandlingEndpointSupport.class.isAssignableFrom(beanType);
    }

    protected final HandlerExecutionChain getHandlerExecutionChain(Object handler, HttpServletRequest request) {
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            handler = handlerMethod.getBean();
        }
        return super.getHandlerExecutionChain(handler, request);
    }

    protected final void detectHandlerMethods(Object handler) {
        RequestMappingInfo mapping;
        if (handler instanceof String) {
            handler = this.getApplicationContext().getBean((String)handler);
        }
        if ((mapping = this.getMappingForEndpoint((HttpRequestHandlingEndpointSupport)((Object)handler))) != null) {
            this.registerHandlerMethod(handler, HANDLE_REQUEST_METHOD, mapping);
        }
    }

    private RequestMappingInfo getMappingForEndpoint(HttpRequestHandlingEndpointSupport endpoint) {
        final RequestMapping requestMapping = endpoint.getRequestMapping();
        if (ObjectUtils.isEmpty((Object[])requestMapping.getPathPatterns())) {
            return null;
        }
        org.springframework.web.bind.annotation.RequestMapping requestMappingAnnotation = new org.springframework.web.bind.annotation.RequestMapping(){

            public String[] value() {
                return requestMapping.getPathPatterns();
            }

            public RequestMethod[] method() {
                return requestMapping.getRequestMethods();
            }

            public String[] params() {
                return requestMapping.getParams();
            }

            public String[] headers() {
                return requestMapping.getHeaders();
            }

            public String[] consumes() {
                return requestMapping.getConsumes();
            }

            public String[] produces() {
                return requestMapping.getProduces();
            }

            public Class<? extends Annotation> annotationType() {
                return org.springframework.web.bind.annotation.RequestMapping.class;
            }
        };
        Object[] createRequestMappingInfoParams = new Object[]{requestMappingAnnotation, this.getCustomTypeCondition(((Object)((Object)endpoint)).getClass())};
        return (RequestMappingInfo)ReflectionUtils.invokeMethod((Method)CREATE_REQUEST_MAPPING_INFO_METHOD, (Object)((Object)this), (Object[])createRequestMappingInfoParams);
    }

    static {
        ReflectionUtils.makeAccessible((Method)CREATE_REQUEST_MAPPING_INFO_METHOD);
    }
}

