/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.outbound;

import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.expression.spel.support.StandardTypeConverter;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.integration.Message;
import org.springframework.integration.MessageHandlingException;
import org.springframework.integration.MessagingException;
import org.springframework.integration.expression.ExpressionEvalMap;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.http.support.DefaultHttpHeaderMapper;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class HttpRequestExecutingMessageHandler
extends AbstractReplyProducingMessageHandler {
    private final Map<String, Expression> uriVariableExpressions = new HashMap<String, Expression>();
    private final RestTemplate restTemplate;
    private volatile StandardEvaluationContext evaluationContext;
    private final Expression uriExpression;
    private volatile boolean encodeUri = true;
    private volatile Expression httpMethodExpression = new LiteralExpression(HttpMethod.POST.name());
    private volatile boolean expectReply = true;
    private volatile Expression expectedResponseTypeExpression;
    private volatile boolean extractPayload = true;
    private volatile boolean extractPayloadExplicitlySet = false;
    private volatile String charset = "UTF-8";
    private volatile boolean transferCookies = false;
    private volatile HeaderMapper<HttpHeaders> headerMapper = DefaultHttpHeaderMapper.outboundMapper();
    private volatile Expression uriVariablesExpression;

    public HttpRequestExecutingMessageHandler(URI uri) {
        this(uri.toString());
    }

    public HttpRequestExecutingMessageHandler(String uri) {
        this(uri, null);
    }

    public HttpRequestExecutingMessageHandler(Expression uriExpression) {
        this(uriExpression, null);
    }

    public HttpRequestExecutingMessageHandler(String uri, RestTemplate restTemplate) {
        this((Expression)new LiteralExpression(uri), restTemplate);
        Assert.hasText((String)uri, (String)"URI is required");
    }

    public HttpRequestExecutingMessageHandler(Expression uriExpression, RestTemplate restTemplate) {
        Assert.notNull((Object)uriExpression, (String)"URI Expression is required");
        this.restTemplate = restTemplate == null ? new RestTemplate() : restTemplate;
        this.uriExpression = uriExpression;
    }

    public void setEncodeUri(boolean encodeUri) {
        this.encodeUri = encodeUri;
    }

    public void setHttpMethodExpression(Expression httpMethodExpression) {
        Assert.notNull((Object)httpMethodExpression, (String)"'httpMethodExpression' must not be null");
        this.httpMethodExpression = httpMethodExpression;
    }

    public void setHttpMethod(HttpMethod httpMethod) {
        this.httpMethodExpression = new LiteralExpression(httpMethod.name());
    }

    public void setExtractPayload(boolean extractPayload) {
        this.extractPayload = extractPayload;
        this.extractPayloadExplicitlySet = true;
    }

    public void setCharset(String charset) {
        Assert.isTrue((boolean)Charset.isSupported(charset), (String)("unsupported charset '" + charset + "'"));
        this.charset = charset;
    }

    public void setExpectReply(boolean expectReply) {
        this.expectReply = expectReply;
    }

    public void setExpectedResponseType(Class<?> expectedResponseType) {
        Assert.notNull(expectedResponseType, (String)"'expectedResponseType' must not be null");
        this.expectedResponseTypeExpression = new LiteralExpression(expectedResponseType.getName());
    }

    public void setExpectedResponseTypeExpression(Expression expectedResponseTypeExpression) {
        this.expectedResponseTypeExpression = expectedResponseTypeExpression;
    }

    public void setErrorHandler(ResponseErrorHandler errorHandler) {
        this.restTemplate.setErrorHandler(errorHandler);
    }

    public void setMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        this.restTemplate.setMessageConverters(messageConverters);
    }

    public void setHeaderMapper(HeaderMapper<HttpHeaders> headerMapper) {
        Assert.notNull(headerMapper, (String)"headerMapper must not be null");
        this.headerMapper = headerMapper;
    }

    public void setRequestFactory(ClientHttpRequestFactory requestFactory) {
        this.restTemplate.setRequestFactory(requestFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUriVariableExpressions(Map<String, Expression> uriVariableExpressions) {
        Map<String, Expression> map = this.uriVariableExpressions;
        synchronized (map) {
            this.uriVariableExpressions.clear();
            this.uriVariableExpressions.putAll(uriVariableExpressions);
        }
    }

    public void setUriVariablesExpression(Expression uriVariablesExpression) {
        this.uriVariablesExpression = uriVariablesExpression;
    }

    public void setTransferCookies(boolean transferCookies) {
        this.transferCookies = transferCookies;
    }

    protected void doInit() {
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
        ConversionService conversionService = this.getConversionService();
        if (conversionService == null) {
            conversionService = new GenericConversionService();
        }
        if (conversionService instanceof ConverterRegistry) {
            ConverterRegistry converterRegistry = (ConverterRegistry)conversionService;
            converterRegistry.addConverter((Converter)new ClassToStringConverter());
            converterRegistry.addConverter((Converter)new ObjectToStringConverter());
            this.evaluationContext.setTypeConverter((TypeConverter)new StandardTypeConverter(conversionService));
        } else {
            this.logger.warn((Object)"ConversionService is not an instance of ConverterRegistry thereforeClassToStringConverter and ObjectToStringConverter will not be registered");
        }
    }

    protected Object handleRequestMessage(Message<?> requestMessage) {
        String uri = (String)this.uriExpression.getValue((EvaluationContext)this.evaluationContext, requestMessage, String.class);
        Assert.notNull((Object)uri, (String)"URI Expression evaluation cannot result in null");
        try {
            HttpMethod httpMethod = this.determineHttpMethod(requestMessage);
            if (!this.shouldIncludeRequestBody(httpMethod) && this.extractPayloadExplicitlySet && this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("The 'extractPayload' attribute has no relevance for the current request since the HTTP Method is '" + httpMethod + "', and no request body will be sent for that method."));
            }
            Class<?> expectedResponseType = this.determineExpectedResponseType(requestMessage);
            HttpEntity<?> httpRequest = this.generateHttpRequest(requestMessage, httpMethod);
            Map<String, ?> uriVariables = this.determineUriVariables(requestMessage);
            UriComponents uriComponents = UriComponentsBuilder.fromUriString((String)uri).buildAndExpand(uriVariables);
            URI realUri = this.encodeUri ? uriComponents.toUri() : new URI(uriComponents.toUriString());
            ResponseEntity httpResponse = this.restTemplate.exchange(realUri, httpMethod, httpRequest, expectedResponseType);
            if (this.expectReply) {
                Object responseBody;
                HttpHeaders httpHeaders = httpResponse.getHeaders();
                Map headers = this.headerMapper.toHeaders((Object)httpHeaders);
                if (this.transferCookies) {
                    this.doConvertSetCookie(headers);
                }
                MessageBuilder replyBuilder = null;
                replyBuilder = httpResponse.hasBody() ? ((responseBody = httpResponse.getBody()) instanceof Message ? MessageBuilder.fromMessage((Message)((Message)responseBody)) : MessageBuilder.withPayload((Object)responseBody)) : MessageBuilder.withPayload((Object)httpResponse);
                replyBuilder.setHeader("http_statusCode", (Object)httpResponse.getStatusCode());
                return replyBuilder.copyHeaders(headers).build();
            }
            return null;
        }
        catch (MessagingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageHandlingException(requestMessage, "HTTP request execution failed for URI [" + uri + "]", (Throwable)e);
        }
    }

    private void doConvertSetCookie(Map<String, Object> headers) {
        String keyName = null;
        for (String key : headers.keySet()) {
            if (!key.equalsIgnoreCase("Set-Cookie")) continue;
            keyName = key;
            break;
        }
        if (keyName != null) {
            Object cookies = headers.remove(keyName);
            headers.put("Cookie", cookies);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Converted Set-Cookie header to Cookie for: " + cookies));
            }
        }
    }

    private HttpEntity<?> generateHttpRequest(Message<?> message, HttpMethod httpMethod) throws Exception {
        Assert.notNull(message, (String)"message must not be null");
        return this.extractPayload ? this.createHttpEntityFromPayload(message, httpMethod) : this.createHttpEntityFromMessage(message, httpMethod);
    }

    private HttpEntity<?> createHttpEntityFromPayload(Message<?> message, HttpMethod httpMethod) {
        MultiValueMap<Object, Object> payload = message.getPayload();
        if (payload instanceof HttpEntity) {
            return (HttpEntity)payload;
        }
        HttpHeaders httpHeaders = this.mapHeaders(message);
        if (!this.shouldIncludeRequestBody(httpMethod)) {
            return new HttpEntity((MultiValueMap)httpHeaders);
        }
        if (httpHeaders.getContentType() == null) {
            MediaType contentType = payload instanceof String ? this.resolveContentType((String)payload, this.charset) : this.resolveContentType(payload);
            httpHeaders.setContentType(contentType);
        }
        if ((MediaType.APPLICATION_FORM_URLENCODED.equals((Object)httpHeaders.getContentType()) || MediaType.MULTIPART_FORM_DATA.equals((Object)httpHeaders.getContentType())) && !(payload instanceof MultiValueMap)) {
            payload = this.convertToMultiValueMap((Map)payload);
        }
        return new HttpEntity(payload, (MultiValueMap)httpHeaders);
    }

    private HttpEntity<?> createHttpEntityFromMessage(Message<?> message, HttpMethod httpMethod) {
        HttpHeaders httpHeaders = this.mapHeaders(message);
        if (this.shouldIncludeRequestBody(httpMethod)) {
            httpHeaders.setContentType(new MediaType("application", "x-java-serialized-object"));
            return new HttpEntity(message, (MultiValueMap)httpHeaders);
        }
        return new HttpEntity((MultiValueMap)httpHeaders);
    }

    protected HttpHeaders mapHeaders(Message<?> message) {
        HttpHeaders httpHeaders = new HttpHeaders();
        this.headerMapper.fromHeaders(message.getHeaders(), (Object)httpHeaders);
        return httpHeaders;
    }

    private MediaType resolveContentType(Object content) {
        MediaType contentType = null;
        if (content instanceof byte[]) {
            contentType = MediaType.APPLICATION_OCTET_STREAM;
        } else if (content instanceof Source) {
            contentType = MediaType.TEXT_XML;
        } else if (content instanceof Map && this.isFormData((Map)content)) {
            contentType = this.isMultipart((Map)content) ? MediaType.MULTIPART_FORM_DATA : MediaType.APPLICATION_FORM_URLENCODED;
        }
        if (contentType == null) {
            contentType = new MediaType("application", "x-java-serialized-object");
        }
        return contentType;
    }

    private boolean shouldIncludeRequestBody(HttpMethod httpMethod) {
        return !HttpMethod.GET.equals((Object)httpMethod);
    }

    private MediaType resolveContentType(String content, String charset) {
        return new MediaType("text", "plain", Charset.forName(charset));
    }

    private MultiValueMap<Object, Object> convertToMultiValueMap(Map<?, ?> simpleMap) {
        LinkedMultiValueMap multipartValueMap = new LinkedMultiValueMap();
        for (Object key : simpleMap.keySet()) {
            Object value = simpleMap.get(key);
            if (value instanceof Object[]) {
                Object[] valueArray = (Object[])value;
                value = Arrays.asList(valueArray);
            }
            if (value instanceof Collection) {
                multipartValueMap.put(key, new ArrayList((Collection)value));
                continue;
            }
            multipartValueMap.add(key, value);
        }
        return multipartValueMap;
    }

    private boolean isMultipart(Map<String, ?> map) {
        for (String key : map.keySet()) {
            Object value = map.get(key);
            if (value == null) continue;
            if (value.getClass().isArray()) {
                value = CollectionUtils.arrayToList(value);
            }
            if (value instanceof Collection) {
                Collection cValues = (Collection)value;
                for (Object cValue : cValues) {
                    if (cValue == null || cValue instanceof String) continue;
                    return true;
                }
                continue;
            }
            if (value instanceof String) continue;
            return true;
        }
        return false;
    }

    private boolean isFormData(Map<Object, ?> map) {
        for (Object key : map.keySet()) {
            if (key instanceof String) continue;
            return false;
        }
        return true;
    }

    private HttpMethod determineHttpMethod(Message<?> requestMessage) {
        String strHttpMethod = (String)this.httpMethodExpression.getValue((EvaluationContext)this.evaluationContext, requestMessage, String.class);
        Assert.isTrue((StringUtils.hasText((String)strHttpMethod) && !Arrays.asList(HttpMethod.values()).contains(strHttpMethod) ? 1 : 0) != 0, (String)("The 'httpMethodExpression' returned an invalid HTTP Method value: " + strHttpMethod));
        return HttpMethod.valueOf((String)strHttpMethod);
    }

    private Class<?> determineExpectedResponseType(Message<?> requestMessage) throws Exception {
        Class expectedResponseType = null;
        String expectedResponseTypeName = null;
        if (this.expectedResponseTypeExpression != null) {
            expectedResponseTypeName = (String)this.expectedResponseTypeExpression.getValue((EvaluationContext)this.evaluationContext, requestMessage, String.class);
        }
        if (StringUtils.hasText(expectedResponseTypeName)) {
            expectedResponseType = ClassUtils.forName(expectedResponseTypeName, (ClassLoader)ClassUtils.getDefaultClassLoader());
        }
        return expectedResponseType;
    }

    private Map<String, ?> determineUriVariables(Message<?> requestMessage) {
        Map expressions = this.uriVariablesExpression != null ? (Map)this.uriVariablesExpression.getValue((EvaluationContext)this.evaluationContext, requestMessage, Map.class) : this.uriVariableExpressions;
        return ExpressionEvalMap.from(expressions).usingEvaluationContext((EvaluationContext)this.evaluationContext).withRoot(requestMessage).build();
    }

    private class ObjectToStringConverter
    implements Converter<Object, String> {
        private ObjectToStringConverter() {
        }

        public String convert(Object source) {
            if (source instanceof Class) {
                return ((Class)source).getName();
            }
            return source.toString();
        }
    }

    private class ClassToStringConverter
    implements Converter<Class<?>, String> {
        private ClassToStringConverter() {
        }

        public String convert(Class<?> source) {
            return source.getName();
        }
    }
}

