/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.inbound;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.integration.http.inbound.BaseHttpInboundEndpoint;
import org.springframework.integration.http.inbound.HttpRequestHandlingEndpointSupport;
import org.springframework.integration.http.inbound.IntegrationRequestMappingHandlerMapping;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;

public class DynamicRequestMappingBeanPostProcessor
implements BeanFactoryAware,
DestructionAwareBeanPostProcessor,
SmartInitializingSingleton {
    private BeanFactory beanFactory;
    private IntegrationRequestMappingHandlerMapping integrationRequestMappingHandlerMapping;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void afterSingletonsInstantiated() {
        this.integrationRequestMappingHandlerMapping = (IntegrationRequestMappingHandlerMapping)((Object)this.beanFactory.getBean(IntegrationRequestMappingHandlerMapping.class));
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (this.integrationRequestMappingHandlerMapping != null && this.isHandler(bean.getClass())) {
            this.integrationRequestMappingHandlerMapping.detectHandlerMethods(bean);
        }
        return bean;
    }

    public void postProcessBeforeDestruction(Object bean, String beanName) throws BeansException {
        RequestMappingInfo mapping;
        if (this.isHandler(bean.getClass()) && (mapping = this.integrationRequestMappingHandlerMapping.getMappingForEndpoint((BaseHttpInboundEndpoint)((Object)bean))) != null) {
            this.integrationRequestMappingHandlerMapping.unregisterMapping(mapping);
        }
    }

    public boolean requiresDestruction(Object bean) {
        return this.isHandler(bean.getClass());
    }

    private boolean isHandler(Class<?> beanType) {
        return HttpRequestHandlingEndpointSupport.class.isAssignableFrom(beanType);
    }
}

