/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip;

import java.util.Date;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.ip.CommonSocketOptions;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;

public abstract class AbstractInternetProtocolReceivingChannelAdapter
extends MessageProducerSupport
implements Runnable,
CommonSocketOptions {
    protected final int port;
    protected volatile int soTimeout = 0;
    protected volatile int soReceiveBufferSize = -1;
    protected volatile int receiveBufferSize = 2048;
    protected volatile boolean active;
    protected volatile boolean listening;
    protected volatile String localAddress;
    protected volatile Executor taskExecutor;
    protected volatile int poolSize = 5;

    public AbstractInternetProtocolReceivingChannelAdapter(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public void setSoReceiveBufferSize(int soReceiveBufferSize) {
        this.soReceiveBufferSize = soReceiveBufferSize;
    }

    public void setSoSendBufferSize(int soSendBufferSize) {
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    protected void doStart() {
        TaskScheduler taskScheduler = this.getTaskScheduler();
        Assert.state((taskScheduler != null ? 1 : 0) != 0, (String)"taskScheduler is required");
        this.active = true;
        taskScheduler.schedule((Runnable)this, new Date());
    }

    protected void checkTaskExecutor(final String threadName) {
        if (this.active && this.taskExecutor == null) {
            ExecutorService executor = Executors.newFixedThreadPool(this.poolSize, new ThreadFactory(){

                public Thread newThread(Runnable runner) {
                    Thread thread = new Thread(runner);
                    thread.setName(threadName);
                    thread.setDaemon(true);
                    return thread;
                }
            });
            this.taskExecutor = executor;
        }
    }

    protected void doStop() {
        this.active = false;
    }

    public boolean isListening() {
        return this.listening;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public void setTaskExecutor(Executor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }
}

