/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.ip.CommonSocketOptions;
import org.springframework.util.Assert;

public abstract class AbstractInternetProtocolSendingMessageHandler
extends AbstractMessageHandler
implements CommonSocketOptions {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final SocketAddress destinationAddress;
    protected final String host;
    protected final int port;
    protected volatile int soSendBufferSize = -1;
    protected volatile int soTimeout = -1;

    public AbstractInternetProtocolSendingMessageHandler(String host, int port) {
        Assert.notNull((Object)host, (String)"host must not be null");
        this.destinationAddress = new InetSocketAddress(host, port);
        this.host = host;
        this.port = port;
    }

    public void setSoTimeout(int timeout) {
        this.soTimeout = timeout;
    }

    public void setSoReceiveBufferSize(int size) {
    }

    public void setSoSendBufferSize(int size) {
        this.soSendBufferSize = size;
    }

    public int getPort() {
        return this.port;
    }
}

