/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.net.Socket;
import java.net.SocketException;
import org.springframework.integration.ip.tcp.connection.AbstractConnectionFactory;
import org.springframework.integration.ip.tcp.connection.TcpConnection;
import org.springframework.util.Assert;

public abstract class AbstractClientConnectionFactory
extends AbstractConnectionFactory {
    protected TcpConnection theConnection;

    public AbstractClientConnectionFactory(String host, int port) {
        Assert.notNull((Object)host, (String)"host must not be null");
        this.host = host;
        this.port = port;
    }

    protected void initializeConnection(TcpConnection connection, Socket socket) {
        if (this.listener != null) {
            connection.registerListener(this.listener);
        }
        if ((this.listener != null || this.singleUse) && this.soTimeout <= 0) {
            try {
                socket.setSoTimeout(10000);
            }
            catch (SocketException e) {
                this.logger.error((Object)"Error setting default reply timeout", (Throwable)e);
            }
        }
        connection.setMapper(this.mapper);
        connection.setDeserializer(this.deserializer);
        connection.setSerializer(this.serializer);
        connection.setSingleUse(this.singleUse);
    }
}

