/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.net.Socket;
import java.net.SocketTimeoutException;
import org.springframework.integration.Message;
import org.springframework.integration.ip.tcp.connection.AbstractTcpConnection;
import org.springframework.integration.ip.tcp.connection.NoListenerException;
import org.springframework.integration.ip.tcp.serializer.SoftEndOfStreamException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TcpNetConnection
extends AbstractTcpConnection {
    private final Socket socket;
    private boolean noReadErrorOnClose;

    public TcpNetConnection(Socket socket, boolean server, boolean lookupHost) {
        super(socket, server, lookupHost);
        this.socket = socket;
    }

    @Override
    public void close() {
        this.noReadErrorOnClose = true;
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.close();
    }

    @Override
    public boolean isOpen() {
        return !this.socket.isClosed();
    }

    @Override
    public synchronized void send(Message<?> message) throws Exception {
        Object object = this.mapper.fromMessage(message);
        this.serializer.serialize(object, this.socket.getOutputStream());
        this.afterSend(message);
    }

    @Override
    public Object getPayload() throws Exception {
        return this.deserializer.deserialize(this.socket.getInputStream());
    }

    @Override
    public int getPort() {
        return this.socket.getPort();
    }

    @Override
    public void run() {
        if (this.listener == null && !this.singleUse) {
            this.logger.debug((Object)"TcpListener exiting - no listener and not single use");
            return;
        }
        Message<Object> message = null;
        boolean okToRun = true;
        this.logger.debug((Object)"Reading...");
        boolean intercepted = false;
        while (okToRun) {
            try {
                message = this.mapper.toMessage(this);
            }
            catch (Exception e) {
                this.closeConnection();
                if (e instanceof SoftEndOfStreamException) break;
                if (e instanceof SocketTimeoutException && this.singleUse) {
                    this.logger.debug((Object)"Closing single use socket after timeout");
                    break;
                }
                if (this.noReadErrorOnClose) {
                    if (!this.logger.isDebugEnabled()) break;
                    this.logger.debug((Object)("Read exception " + this.getConnectionId() + " " + e.getClass().getSimpleName() + ":" + e.getCause() + ":" + e.getMessage()));
                    break;
                }
                if (this.logger.isTraceEnabled()) {
                    this.logger.error((Object)("Read exception " + this.getConnectionId()), (Throwable)e);
                    break;
                }
                this.logger.error((Object)("Read exception " + this.getConnectionId() + " " + e.getClass().getSimpleName() + ":" + e.getCause() + ":" + e.getMessage()));
                break;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Message received " + message));
            }
            try {
                if (this.listener == null) {
                    this.logger.warn((Object)("Unexpected message - no inbound adapter registered with connection " + message));
                    continue;
                }
                intercepted = this.listener.onMessage(message);
            }
            catch (Exception e) {
                if (e instanceof NoListenerException) {
                    if (this.singleUse) {
                        this.logger.debug((Object)("Closing single use socket after inbound message " + this.connectionId));
                        this.closeConnection();
                        okToRun = false;
                    } else {
                        this.logger.warn((Object)("Unexpected message - no inbound adapter registered with connection " + message));
                    }
                }
                this.logger.error((Object)("Exception sending meeeage: " + message), (Throwable)e);
            }
            if (!this.singleUse || (this.server || intercepted) && (!this.server || this.sender != null)) continue;
            this.logger.debug((Object)("Closing single use socket after inbound message " + this.connectionId));
            this.closeConnection();
            okToRun = false;
        }
    }
}

