/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.udp;

import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.integration.Message;
import org.springframework.integration.MessageHandlingException;
import org.springframework.integration.ip.util.RegexUtils;
import org.springframework.integration.mapping.InboundMessageMapper;
import org.springframework.integration.mapping.MessageMappingException;
import org.springframework.integration.mapping.OutboundMessageMapper;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatagramPacketMessageMapper
implements InboundMessageMapper<DatagramPacket>,
OutboundMessageMapper<DatagramPacket> {
    private volatile String charset = "UTF-8";
    private boolean acknowledge = false;
    private String ackAddress;
    private boolean lengthCheck = false;
    private boolean lookupHost = true;
    private static Pattern udpHeadersPattern = Pattern.compile(RegexUtils.escapeRegexSpecials("ip_ackTo") + "=" + "([^;]*);" + RegexUtils.escapeRegexSpecials("id") + "=" + "([^;]*);");

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setAcknowledge(boolean acknowledge) {
        this.acknowledge = acknowledge;
    }

    public void setAckAddress(String ackAddress) {
        this.ackAddress = ackAddress;
    }

    public void setLengthCheck(boolean lengthCheck) {
        this.lengthCheck = lengthCheck;
    }

    public void setLookupHost(boolean lookupHost) {
        this.lookupHost = lookupHost;
    }

    public DatagramPacket fromMessage(Message<?> message) throws Exception {
        if (this.acknowledge) {
            return this.fromMessageWithAck(message);
        }
        byte[] bytes = this.getPayloadAsBytes(message);
        if (this.lengthCheck) {
            ByteBuffer buffer = ByteBuffer.allocate(bytes.length + 4);
            buffer.putInt(bytes.length);
            buffer.put(bytes);
            bytes = buffer.array();
        }
        return new DatagramPacket(bytes, bytes.length);
    }

    private DatagramPacket fromMessageWithAck(Message<?> message) throws Exception {
        Assert.hasLength((String)this.ackAddress);
        byte[] bytes = this.getPayloadAsBytes(message);
        ByteBuffer buffer = ByteBuffer.allocate(100 + bytes.length);
        if (this.lengthCheck) {
            buffer.putInt(0);
        }
        buffer.put("ip_ackTo".getBytes(this.charset));
        buffer.put((byte)61);
        buffer.put(this.ackAddress.getBytes(this.charset));
        buffer.put((byte)59);
        buffer.put("id".getBytes(this.charset));
        buffer.put((byte)61);
        buffer.put(message.getHeaders().getId().toString().getBytes(this.charset));
        buffer.put((byte)59);
        int headersLength = buffer.position() - 4;
        buffer.put(bytes);
        if (this.lengthCheck) {
            buffer.putInt(0, bytes.length + headersLength);
        }
        return new DatagramPacket(buffer.array(), buffer.position());
    }

    private byte[] getPayloadAsBytes(Message<?> message) {
        byte[] bytes = null;
        Object payload = message.getPayload();
        if (payload instanceof byte[]) {
            bytes = (byte[])payload;
        } else if (payload instanceof String) {
            try {
                bytes = ((String)payload).getBytes(this.charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new MessageHandlingException(message, (Throwable)e);
            }
        } else {
            throw new MessageHandlingException(message, "The datagram packet mapper expects either a byte array or String payload, but received: " + payload.getClass());
        }
        return bytes;
    }

    public Message<byte[]> toMessage(DatagramPacket packet) throws Exception {
        byte[] payload;
        int offset = packet.getOffset();
        int length = packet.getLength();
        ByteBuffer buffer = ByteBuffer.wrap(packet.getData(), offset, length);
        Message message = null;
        if (this.lengthCheck) {
            int declaredLength = buffer.getInt();
            if (declaredLength != length - 4) {
                throw new MessageMappingException("Incorrect length; expected " + (declaredLength + 4) + ", received " + length);
            }
            offset += 4;
            length -= 4;
        }
        String hostAddress = packet.getAddress().getHostAddress();
        String hostName = this.lookupHost ? packet.getAddress().getHostName() : hostAddress;
        if (this.acknowledge || this.startsWith(buffer, "ip_ackTo")) {
            try {
                String headers = new String(packet.getData(), offset, length, this.charset);
                Matcher matcher = udpHeadersPattern.matcher(headers);
                if (matcher.find()) {
                    payload = new byte[length -= matcher.end()];
                    System.arraycopy(packet.getData(), offset + matcher.end(), payload, 0, length);
                    message = MessageBuilder.withPayload((Object)payload).setHeader("ip_ackId", (Object)UUID.fromString(matcher.group(2))).setHeader("ip_ackTo", (Object)matcher.group(1)).setHeader("ip_hostname", (Object)hostName).setHeader("ip_address", (Object)hostAddress).build();
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new MessageMappingException("Invalid charset", (Throwable)e);
            }
        }
        if (message == null) {
            payload = new byte[length];
            System.arraycopy(packet.getData(), offset, payload, 0, length);
            if (payload.length > 0) {
                message = MessageBuilder.withPayload((Object)payload).setHeader("ip_hostname", (Object)hostName).setHeader("ip_address", (Object)hostAddress).build();
            }
        }
        return message;
    }

    private boolean startsWith(ByteBuffer buffer, String prefix) {
        int pos = buffer.position();
        if (buffer.limit() - pos < prefix.length()) {
            return false;
        }
        try {
            byte[] comparing = prefix.getBytes(this.charset);
            for (int i = 0; i < comparing.length; ++i) {
                if (buffer.get() == comparing[i]) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (UnsupportedEncodingException e) {
            throw new MessageMappingException("Invalid charset", (Throwable)e);
        }
        finally {
            buffer.position(pos);
        }
    }
}

