/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.udp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.integration.Message;
import org.springframework.integration.MessageHeaders;
import org.springframework.integration.MessagingException;
import org.springframework.integration.ip.AbstractInternetProtocolReceivingChannelAdapter;
import org.springframework.integration.ip.udp.DatagramPacketMessageMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnicastReceivingChannelAdapter
extends AbstractInternetProtocolReceivingChannelAdapter {
    protected volatile DatagramSocket socket;
    protected final DatagramPacketMessageMapper mapper = new DatagramPacketMessageMapper();
    protected volatile int soSendBufferSize = -1;
    private static Pattern addressPattern = Pattern.compile("([^:]*):([0-9]*)");

    public UnicastReceivingChannelAdapter(int port) {
        super(port);
        this.mapper.setLengthCheck(false);
    }

    public UnicastReceivingChannelAdapter(int port, boolean lengthCheck) {
        super(port);
        this.mapper.setLengthCheck(lengthCheck);
    }

    @Override
    public void run() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("UDP Receiver running on port:" + this.port));
        }
        this.checkTaskExecutor("UDP-Incoming-Msg-Handler");
        this.listening = true;
        while (this.active) {
            try {
                this.asyncSendMessage(this.receive());
            }
            catch (SocketTimeoutException e) {
            }
            catch (SocketException e) {
                this.doStop();
            }
            catch (Exception e) {
                if (e instanceof MessagingException) {
                    throw (MessagingException)e;
                }
                throw new MessagingException("failed to receive DatagramPacket", (Throwable)e);
            }
        }
        this.listening = false;
    }

    protected void sendAck(Message<byte[]> message) {
        MessageHeaders headers = message.getHeaders();
        Object id = headers.get((Object)"ip_ackId");
        byte[] ack = id.toString().getBytes();
        String ackAddress = ((String)headers.get((Object)"ip_ackTo")).trim();
        Matcher mat = addressPattern.matcher(ackAddress);
        if (!mat.matches()) {
            throw new MessagingException(message, "Ack requested but could not decode acknowledgment address:" + ackAddress);
        }
        String host = mat.group(1);
        int port = Integer.parseInt(mat.group(2));
        InetSocketAddress whereTo = new InetSocketAddress(host, port);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Sending ack for " + id + " to " + ackAddress));
        }
        try {
            DatagramPacket ackPack = new DatagramPacket(ack, ack.length, whereTo);
            DatagramSocket out = new DatagramSocket();
            if (this.soSendBufferSize > 0) {
                out.setSendBufferSize(this.soSendBufferSize);
            }
            out.send(ackPack);
            out.close();
        }
        catch (IOException e) {
            throw new MessagingException(message, "Failed to send acknowledgment", (Throwable)e);
        }
    }

    protected boolean asyncSendMessage(final DatagramPacket packet) {
        this.taskExecutor.execute(new Runnable(){

            public void run() {
                Message<byte[]> message = null;
                try {
                    message = UnicastReceivingChannelAdapter.this.mapper.toMessage(packet);
                    if (UnicastReceivingChannelAdapter.this.logger.isDebugEnabled()) {
                        UnicastReceivingChannelAdapter.this.logger.debug((Object)("Received:" + message));
                    }
                }
                catch (Exception e) {
                    UnicastReceivingChannelAdapter.this.logger.error((Object)"Failed to map packet to message ", (Throwable)e);
                }
                if (message != null) {
                    if (message.getHeaders().containsKey((Object)"ip_ackTo")) {
                        UnicastReceivingChannelAdapter.this.sendAck(message);
                    }
                    UnicastReceivingChannelAdapter.this.sendMessage(message);
                }
            }
        });
        return true;
    }

    protected DatagramPacket receive() throws Exception {
        DatagramSocket socket = this.getSocket();
        byte[] buffer = new byte[this.receiveBufferSize];
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
        socket.receive(packet);
        return packet;
    }

    protected synchronized DatagramSocket getSocket() {
        if (this.socket == null) {
            try {
                if (this.localAddress == null) {
                    this.socket = new DatagramSocket(this.port);
                } else {
                    InetAddress whichNic = InetAddress.getByName(this.localAddress);
                    this.socket = new DatagramSocket(this.port, whichNic);
                }
                this.socket.setSoTimeout(this.soTimeout);
                if (this.soReceiveBufferSize > 0) {
                    this.socket.setReceiveBufferSize(this.soReceiveBufferSize);
                }
            }
            catch (IOException e) {
                throw new MessagingException("failed to create DatagramSocket", (Throwable)e);
            }
        }
        return this.socket;
    }

    @Override
    protected void doStop() {
        super.doStop();
        try {
            this.socket.close();
            this.socket = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setSoSendBufferSize(int soSendBufferSize) {
        this.soSendBufferSize = soSendBufferSize;
    }

    public void setLookupHost(boolean lookupHost) {
        this.mapper.setLookupHost(lookupHost);
    }

    public String getComponentType() {
        return "ip:udp-inbound-channel-adapter";
    }
}

