/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.Serializer;
import org.springframework.integration.Message;
import org.springframework.integration.ip.tcp.connection.AbstractClientConnectionFactory;
import org.springframework.integration.ip.tcp.connection.TcpConnection;
import org.springframework.integration.ip.tcp.connection.TcpListener;
import org.springframework.integration.ip.tcp.connection.TcpMessageMapper;
import org.springframework.integration.ip.tcp.connection.TcpSender;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FailoverClientConnectionFactory
extends AbstractClientConnectionFactory {
    private static final Log logger = LogFactory.getLog(FailoverClientConnectionFactory.class);
    private final List<AbstractClientConnectionFactory> factories;

    public FailoverClientConnectionFactory(List<AbstractClientConnectionFactory> factories) {
        super("", 0);
        Assert.notEmpty(factories, (String)"At least one factory is required");
        this.factories = factories;
    }

    protected void onInit() throws Exception {
        super.onInit();
        for (AbstractClientConnectionFactory factory : this.factories) {
            Assert.state((!(this.isSingleUse() ^ factory.isSingleUse()) ? 1 : 0) != 0, (String)"Inconsistent singleUse - delegate factories must match this one");
        }
    }

    @Override
    public void registerListener(TcpListener listener) {
        super.registerListener(listener);
        for (AbstractClientConnectionFactory factory : this.factories) {
            factory.registerListener(new TcpListener(){

                @Override
                public boolean onMessage(Message<?> message) {
                    throw new UnsupportedOperationException("This should never be called");
                }
            });
        }
    }

    @Override
    public void registerSender(TcpSender sender) {
        for (AbstractClientConnectionFactory factory : this.factories) {
            factory.registerSender(sender);
        }
    }

    @Override
    protected TcpConnection obtainConnection() throws Exception {
        TcpConnection connection = this.getTheConnection();
        if (connection != null && connection.isOpen()) {
            return connection;
        }
        return new FailoverTcpConnection(this.factories);
    }

    @Override
    public void close() {
        for (AbstractClientConnectionFactory factory : this.factories) {
            factory.close();
        }
    }

    @Override
    public void start() {
        for (AbstractClientConnectionFactory factory : this.factories) {
            factory.start();
        }
        this.setActive(true);
        super.start();
    }

    @Override
    public void stop() {
        this.setActive(false);
        for (AbstractClientConnectionFactory factory : this.factories) {
            factory.stop();
        }
    }

    @Override
    public boolean isRunning() {
        boolean isRunning = true;
        for (AbstractClientConnectionFactory factory : this.factories) {
            isRunning = !isRunning ? false : factory.isRunning();
        }
        return isRunning;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FailoverTcpConnection
    implements TcpConnection,
    TcpListener {
        private final List<AbstractClientConnectionFactory> factories;
        private final String connectionId;
        private volatile Iterator<AbstractClientConnectionFactory> factoryIterator;
        private volatile AbstractClientConnectionFactory currentFactory;
        private volatile TcpConnection delegate;
        private volatile boolean open = true;

        public FailoverTcpConnection(List<AbstractClientConnectionFactory> factories) throws Exception {
            this.factories = factories;
            this.factoryIterator = factories.iterator();
            this.findAConnection();
            this.connectionId = UUID.randomUUID().toString();
        }

        private synchronized void findAConnection() throws Exception {
            boolean success = false;
            AbstractClientConnectionFactory lastFactoryToTry = this.currentFactory;
            AbstractClientConnectionFactory nextFactory = null;
            if (!this.factoryIterator.hasNext()) {
                this.factoryIterator = this.factories.iterator();
            }
            boolean retried = false;
            while (!success) {
                try {
                    nextFactory = this.factoryIterator.next();
                    this.delegate = nextFactory.getConnection();
                    this.delegate.registerListener(this);
                    this.currentFactory = nextFactory;
                    success = this.delegate.isOpen();
                }
                catch (IOException e) {
                    if (this.factoryIterator.hasNext()) continue;
                    if (retried && lastFactoryToTry == null || lastFactoryToTry == nextFactory) {
                        this.open = false;
                        throw e;
                    }
                    this.factoryIterator = this.factories.iterator();
                    retried = true;
                }
            }
        }

        @Override
        public void close() {
            this.delegate.close();
            this.open = false;
        }

        @Override
        public boolean isOpen() {
            return this.open;
        }

        @Override
        public synchronized void send(Message<?> message) throws Exception {
            boolean success = false;
            AbstractClientConnectionFactory lastFactoryToTry = this.currentFactory;
            AbstractClientConnectionFactory lastFactoryTried = null;
            boolean retried = false;
            while (!success) {
                try {
                    lastFactoryTried = this.currentFactory;
                    this.delegate.send(message);
                    success = true;
                }
                catch (IOException e) {
                    if (retried && lastFactoryTried == lastFactoryToTry) {
                        logger.error((Object)"All connection factories exhausted", (Throwable)e);
                        this.open = false;
                        throw e;
                    }
                    retried = true;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Send to " + this.delegate.getConnectionId() + " failed; attempting failover"), (Throwable)e);
                    }
                    this.delegate.close();
                    this.findAConnection();
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Failing over to " + this.delegate.getConnectionId()));
                }
            }
        }

        @Override
        public Object getPayload() throws Exception {
            return this.delegate.getPayload();
        }

        @Override
        public void run() {
            throw new UnsupportedOperationException("Not supported on FailoverTcpConnection");
        }

        @Override
        public String getHostName() {
            return this.delegate.getHostName();
        }

        @Override
        public String getHostAddress() {
            return this.delegate.getHostAddress();
        }

        @Override
        public int getPort() {
            return this.delegate.getPort();
        }

        @Override
        public void registerListener(TcpListener listener) {
            this.delegate.registerListener(listener);
        }

        @Override
        public void registerSender(TcpSender sender) {
            this.delegate.registerSender(sender);
        }

        @Override
        public String getConnectionId() {
            return this.connectionId;
        }

        @Override
        public void setSingleUse(boolean singleUse) {
            this.delegate.setSingleUse(singleUse);
        }

        @Override
        public boolean isSingleUse() {
            return this.delegate.isSingleUse();
        }

        @Override
        public boolean isServer() {
            return this.delegate.isServer();
        }

        @Override
        public void setMapper(TcpMessageMapper mapper) {
            this.delegate.setMapper(mapper);
        }

        @Override
        public Deserializer<?> getDeserializer() {
            return this.delegate.getDeserializer();
        }

        @Override
        public void setDeserializer(Deserializer<?> deserializer) {
            this.delegate.setDeserializer(deserializer);
        }

        @Override
        public Serializer<?> getSerializer() {
            return this.delegate.getSerializer();
        }

        @Override
        public void setSerializer(Serializer<?> serializer) {
            this.delegate.setSerializer(serializer);
        }

        @Override
        public TcpListener getListener() {
            return this.delegate.getListener();
        }

        @Override
        public long incrementAndGetConnectionSequence() {
            return this.delegate.incrementAndGetConnectionSequence();
        }

        @Override
        public boolean onMessage(Message<?> message) {
            return FailoverClientConnectionFactory.this.getListener().onMessage(MessageBuilder.fromMessage(message).setHeader("ip_connectionId", (Object)this.getConnectionId()).setHeader("ip_actualConnectionId", message.getHeaders().get((Object)"ip_connectionId")).build());
        }
    }
}

