/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection.support;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.integration.ip.tcp.connection.support.TcpSSLContextSupport;
import org.springframework.util.Assert;

public class DefaultTcpSSLContextSupport
implements TcpSSLContextSupport {
    private final String keyStore;
    private final String trustStore;
    private final char[] keyStorePassword;
    private final char[] trustStorePassword;
    private volatile String protocol = "TLS";

    public DefaultTcpSSLContextSupport(String keyStore, String trustStore, String keyStorePassword, String trustStorePassword) {
        this.keyStore = keyStore;
        this.trustStore = trustStore;
        this.keyStorePassword = keyStorePassword.toCharArray();
        this.trustStorePassword = trustStorePassword.toCharArray();
    }

    public SSLContext getSSLContext() throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance("JKS");
        KeyStore ts = KeyStore.getInstance("JKS");
        ks.load(new FileInputStream(new ClassPathResource(this.keyStore).getFile()), this.keyStorePassword);
        ts.load(new FileInputStream(new ClassPathResource(this.trustStore).getFile()), this.trustStorePassword);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(ks, this.keyStorePassword);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
        tmf.init(ts);
        SSLContext sslContext = SSLContext.getInstance(this.protocol);
        sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        return sslContext;
    }

    public void setProtocol(String protocol) {
        Assert.notNull((Object)protocol, (String)"protocol must not be null");
        this.protocol = protocol;
    }
}

