/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.springframework.context.ApplicationListener;
import org.springframework.integration.Message;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.ip.tcp.connection.TcpConnectionEvent;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class TcpConnectionEventListeningMessageProducer
extends MessageProducerSupport
implements ApplicationListener<TcpConnectionEvent> {
    private volatile Set<Class<? extends TcpConnectionEvent>> eventTypes = new HashSet<Class<? extends TcpConnectionEvent>>();

    public void setEventTypes(Class<? extends TcpConnectionEvent>[] eventTypes) {
        Assert.notEmpty((Object[])eventTypes, (String)"at least one event type is required");
        HashSet<Class<? extends TcpConnectionEvent>> eventTypeSet = new HashSet<Class<? extends TcpConnectionEvent>>();
        eventTypeSet.addAll(Arrays.asList(eventTypes));
        this.eventTypes = eventTypeSet;
    }

    public void onApplicationEvent(TcpConnectionEvent event) {
        if (this.isRunning()) {
            if (CollectionUtils.isEmpty(this.eventTypes)) {
                this.sendMessage(this.messageFromEvent(event));
            } else {
                for (Class<? extends TcpConnectionEvent> eventType : this.eventTypes) {
                    if (!eventType.isAssignableFrom(((Object)((Object)event)).getClass())) continue;
                    this.sendMessage(this.messageFromEvent(event));
                    break;
                }
            }
        }
    }

    protected Message<TcpConnectionEvent> messageFromEvent(TcpConnectionEvent event) {
        return MessageBuilder.withPayload((Object)((Object)event)).build();
    }
}

