/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import javax.net.ServerSocketFactory;
import org.springframework.integration.ip.tcp.connection.AbstractServerConnectionFactory;
import org.springframework.integration.ip.tcp.connection.DefaultTcpNetSocketFactorySupport;
import org.springframework.integration.ip.tcp.connection.TcpConnectionSupport;
import org.springframework.integration.ip.tcp.connection.TcpNetConnection;
import org.springframework.integration.ip.tcp.connection.TcpSocketFactorySupport;
import org.springframework.util.Assert;

public class TcpNetServerConnectionFactory
extends AbstractServerConnectionFactory {
    private volatile ServerSocket serverSocket;
    private volatile TcpSocketFactorySupport tcpSocketFactorySupport = new DefaultTcpNetSocketFactorySupport();

    public TcpNetServerConnectionFactory(int port) {
        super(port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ServerSocket theServerSocket = null;
        if (this.getListener() == null) {
            this.logger.info((Object)"No listener bound to server connection factory; will not read; exiting...");
            return;
        }
        try {
            try {
                if (this.getLocalAddress() == null) {
                    theServerSocket = this.createServerSocket(this.getPort(), this.getBacklog(), null);
                } else {
                    InetAddress whichNic = InetAddress.getByName(this.getLocalAddress());
                    theServerSocket = this.createServerSocket(this.getPort(), this.getBacklog(), whichNic);
                }
                this.getTcpSocketSupport().postProcessServerSocket(theServerSocket);
                this.serverSocket = theServerSocket;
                this.setListening(true);
                this.logger.info((Object)("Listening on port " + this.getPort()));
                while (true) {
                    Socket socket;
                    try {
                        socket = this.serverSocket.accept();
                    }
                    catch (SocketTimeoutException ste) {
                        if (!this.logger.isDebugEnabled()) continue;
                        this.logger.debug((Object)"Timed out on accept; continuing");
                        continue;
                    }
                    if (this.isShuttingDown()) {
                        if (this.logger.isInfoEnabled()) {
                            this.logger.info((Object)("New connection from " + socket.getInetAddress().getHostAddress() + " rejected; the server is in the process of shutting down."));
                        }
                        socket.close();
                        continue;
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Accepted connection from " + socket.getInetAddress().getHostAddress()));
                    }
                    this.setSocketAttributes(socket);
                    TcpConnectionSupport connection = new TcpNetConnection(socket, true, this.isLookupHost(), this.getApplicationEventPublisher(), this.getComponentName());
                    connection = this.wrapConnection(connection);
                    this.initializeConnection(connection, socket);
                    this.getTaskExecutor().execute(connection);
                    this.harvestClosedConnections();
                    connection.publishConnectionOpenEvent();
                }
            }
            catch (Exception e) {
                if (e instanceof SocketException && theServerSocket != null) {
                    this.logger.warn((Object)"Server Socket closed");
                } else if (this.isActive()) {
                    this.logger.error((Object)"Error on ServerSocket", (Throwable)e);
                }
                this.setListening(false);
                this.setActive(false);
            }
        }
        catch (Throwable throwable) {
            this.setListening(false);
            this.setActive(false);
            throw throwable;
        }
    }

    protected ServerSocket createServerSocket(int port, int backlog, InetAddress whichNic) throws IOException {
        ServerSocketFactory serverSocketFactory = this.tcpSocketFactorySupport.getServerSocketFactory();
        if (whichNic == null) {
            return serverSocketFactory.createServerSocket(port, Math.abs(backlog));
        }
        return serverSocketFactory.createServerSocket(port, Math.abs(backlog), whichNic);
    }

    @Override
    public void stop() {
        if (this.serverSocket == null) {
            return;
        }
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.serverSocket = null;
        super.stop();
    }

    protected ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    protected TcpSocketFactorySupport getTcpSocketFactorySupport() {
        return this.tcpSocketFactorySupport;
    }

    public void setTcpSocketFactorySupport(TcpSocketFactorySupport tcpSocketFactorySupport) {
        Assert.notNull((Object)tcpSocketFactorySupport, (String)"TcpSocketFactorySupport may not be null");
        this.tcpSocketFactorySupport = tcpSocketFactorySupport;
    }
}

