/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLSession;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.Serializer;
import org.springframework.integration.ip.tcp.connection.AbstractClientConnectionFactory;
import org.springframework.integration.ip.tcp.connection.TcpConnectionSupport;
import org.springframework.integration.ip.tcp.connection.TcpListener;
import org.springframework.integration.ip.tcp.connection.TcpMessageMapper;
import org.springframework.integration.ip.tcp.connection.TcpSender;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class FailoverClientConnectionFactory
extends AbstractClientConnectionFactory {
    private final List<AbstractClientConnectionFactory> factories;

    public FailoverClientConnectionFactory(List<AbstractClientConnectionFactory> factories) {
        super("", 0);
        Assert.notEmpty(factories, (String)"At least one factory is required");
        this.factories = factories;
    }

    @Override
    protected void onInit() throws Exception {
        super.onInit();
        for (AbstractClientConnectionFactory factory : this.factories) {
            Assert.state((!(this.isSingleUse() ^ factory.isSingleUse()) ? 1 : 0) != 0, (String)"Inconsistent singleUse - delegate factories must match this one");
            factory.enableManualListenerRegistration();
        }
    }

    @Override
    public void registerListener(TcpListener listener) {
        super.registerListener(listener);
    }

    @Override
    public void registerSender(TcpSender sender) {
        for (AbstractClientConnectionFactory factory : this.factories) {
            factory.registerSender(sender);
        }
    }

    @Override
    protected TcpConnectionSupport obtainConnection() throws Exception {
        TcpConnectionSupport connection = this.getTheConnection();
        if (connection != null && connection.isOpen()) {
            ((FailoverTcpConnection)connection).incrementEpoch();
            return connection;
        }
        FailoverTcpConnection failoverTcpConnection = new FailoverTcpConnection(this.factories);
        if (this.getListener() != null) {
            failoverTcpConnection.registerListener(this.getListener());
        }
        failoverTcpConnection.incrementEpoch();
        return failoverTcpConnection;
    }

    @Override
    public void start() {
        for (AbstractClientConnectionFactory factory : this.factories) {
            factory.enableManualListenerRegistration();
            factory.start();
        }
        this.setActive(true);
        super.start();
    }

    @Override
    public void stop() {
        this.setActive(false);
        for (AbstractClientConnectionFactory factory : this.factories) {
            factory.stop();
        }
    }

    @Override
    public boolean isRunning() {
        boolean isRunning = true;
        for (AbstractClientConnectionFactory factory : this.factories) {
            isRunning = !isRunning ? false : factory.isRunning();
        }
        return isRunning;
    }

    private class FailoverTcpConnection
    extends TcpConnectionSupport
    implements TcpListener {
        private final List<AbstractClientConnectionFactory> factories;
        private final String connectionId;
        private volatile Iterator<AbstractClientConnectionFactory> factoryIterator;
        private volatile AbstractClientConnectionFactory currentFactory;
        private volatile TcpConnectionSupport delegate;
        private volatile boolean open = true;
        private final AtomicLong epoch = new AtomicLong();

        public FailoverTcpConnection(List<AbstractClientConnectionFactory> factories) throws Exception {
            this.factories = factories;
            this.factoryIterator = factories.iterator();
            this.findAConnection();
            this.connectionId = UUID.randomUUID().toString();
        }

        void incrementEpoch() {
            this.epoch.incrementAndGet();
        }

        private synchronized void findAConnection() throws Exception {
            boolean success = false;
            AbstractClientConnectionFactory lastFactoryToTry = this.currentFactory;
            AbstractClientConnectionFactory nextFactory = null;
            if (!this.factoryIterator.hasNext()) {
                this.factoryIterator = this.factories.iterator();
            }
            boolean retried = false;
            while (!success) {
                try {
                    nextFactory = this.factoryIterator.next();
                    this.delegate = nextFactory.getConnection();
                    this.delegate.registerListener(this);
                    this.currentFactory = nextFactory;
                    success = this.delegate.isOpen();
                }
                catch (IOException e) {
                    if (this.factoryIterator.hasNext()) continue;
                    if (retried && lastFactoryToTry == null || lastFactoryToTry == nextFactory) {
                        this.open = false;
                        throw e;
                    }
                    this.factoryIterator = this.factories.iterator();
                    retried = true;
                }
            }
        }

        @Override
        public void close() {
            this.delegate.close();
            this.open = false;
        }

        @Override
        public boolean isOpen() {
            return this.open;
        }

        @Override
        public synchronized void send(Message<?> message) throws Exception {
            boolean success = false;
            AbstractClientConnectionFactory lastFactoryToTry = this.currentFactory;
            AbstractClientConnectionFactory lastFactoryTried = null;
            boolean retried = false;
            while (!success) {
                try {
                    lastFactoryTried = this.currentFactory;
                    this.delegate.send(message);
                    success = true;
                }
                catch (IOException e) {
                    if (retried && lastFactoryTried == lastFactoryToTry) {
                        this.logger.error((Object)"All connection factories exhausted", (Throwable)e);
                        this.open = false;
                        throw e;
                    }
                    retried = true;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Send to " + this.delegate.getConnectionId() + " failed; attempting failover"), (Throwable)e);
                    }
                    this.delegate.close();
                    this.findAConnection();
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("Failing over to " + this.delegate.getConnectionId()));
                }
            }
        }

        @Override
        public Object getPayload() throws Exception {
            return this.delegate.getPayload();
        }

        @Override
        public void run() {
            throw new UnsupportedOperationException("Not supported on FailoverTcpConnection");
        }

        @Override
        public String getHostName() {
            return this.delegate.getHostName();
        }

        @Override
        public String getHostAddress() {
            return this.delegate.getHostAddress();
        }

        @Override
        public int getPort() {
            return this.delegate.getPort();
        }

        @Override
        public Object getDeserializerStateKey() {
            return this.delegate.getDeserializerStateKey();
        }

        @Override
        public void registerSender(TcpSender sender) {
            this.delegate.registerSender(sender);
        }

        @Override
        public String getConnectionId() {
            return this.connectionId + ":" + this.epoch;
        }

        @Override
        public boolean isServer() {
            return this.delegate.isServer();
        }

        @Override
        public void setMapper(TcpMessageMapper mapper) {
            this.delegate.setMapper(mapper);
        }

        @Override
        public Deserializer<?> getDeserializer() {
            return this.delegate.getDeserializer();
        }

        @Override
        public void setDeserializer(Deserializer<?> deserializer) {
            this.delegate.setDeserializer(deserializer);
        }

        @Override
        public Serializer<?> getSerializer() {
            return this.delegate.getSerializer();
        }

        @Override
        public void setSerializer(Serializer<?> serializer) {
            this.delegate.setSerializer(serializer);
        }

        @Override
        public SSLSession getSslSession() {
            return this.delegate.getSslSession();
        }

        @Override
        public boolean onMessage(Message<?> message) {
            if (this.delegate.getConnectionId().equals(message.getHeaders().get((Object)"ip_connectionId"))) {
                AbstractIntegrationMessageBuilder messageBuilder = FailoverClientConnectionFactory.this.getMessageBuilderFactory().fromMessage(message).setHeader("ip_connectionId", (Object)this.getConnectionId());
                if (message.getHeaders().get((Object)"ip_actualConnectionId") == null) {
                    messageBuilder.setHeader("ip_actualConnectionId", message.getHeaders().get((Object)"ip_connectionId"));
                }
                return this.getListener().onMessage(messageBuilder.build());
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Message from defunct connection ignored " + message));
            }
            return false;
        }
    }
}

