/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import org.springframework.integration.ip.tcp.connection.TcpSSLContextSupport;
import org.springframework.integration.ip.tcp.connection.TcpSocketFactorySupport;
import org.springframework.util.Assert;

public class DefaultTcpNetSSLSocketFactorySupport
implements TcpSocketFactorySupport {
    private final SSLContext sslContext;

    public DefaultTcpNetSSLSocketFactorySupport(TcpSSLContextSupport sslContextSupport) {
        Assert.notNull((Object)sslContextSupport, (String)"TcpSSLContextSupport must not be null");
        try {
            this.sslContext = sslContextSupport.getSSLContext();
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("Invalid TcpSSLContextSupport - it failed to provide an SSLContext", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid TcpSSLContextSupport - it failed to provide an SSLContext", e);
        }
        Assert.notNull((Object)this.sslContext, (String)"SSLContext retrieved from context support must not be null");
    }

    @Override
    public ServerSocketFactory getServerSocketFactory() {
        return this.sslContext.getServerSocketFactory();
    }

    @Override
    public SocketFactory getSocketFactory() {
        return this.sslContext.getSocketFactory();
    }

    @Deprecated
    public void afterPropertiesSet() throws Exception {
    }
}

