/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.util;

import org.springframework.integration.ip.tcp.connection.AbstractConnectionFactory;
import org.springframework.integration.ip.tcp.connection.AbstractServerConnectionFactory;

public final class TestingUtilities {
    private TestingUtilities() {
    }

    public static void waitListening(AbstractServerConnectionFactory serverConnectionFactory, Long delay) throws IllegalStateException {
        delay = delay == null ? Long.valueOf(100L) : Long.valueOf(delay / 100L);
        int n = 0;
        while (!serverConnectionFactory.isListening()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e1) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(e1);
            }
            if ((long)n++ <= delay) continue;
            throw new IllegalStateException("Server didn't start listening.");
        }
    }

    public static void waitStopListening(AbstractServerConnectionFactory serverConnectionFactory, Long delay) throws IllegalStateException {
        delay = delay == null ? Long.valueOf(100L) : Long.valueOf(delay / 100L);
        int n = 0;
        while (serverConnectionFactory.isListening()) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(e);
            }
            if (n++ <= 200) continue;
            throw new IllegalStateException("Server didn't stop listening.");
        }
    }

    public static void waitUntilFactoryHasThisNumberOfConnections(AbstractConnectionFactory factory, int n) throws Exception {
        for (int timer = 0; timer < 10000; timer += 100) {
            if (factory.getOpenConnectionIds().size() == n) {
                return;
            }
            Thread.sleep(100L);
        }
        throw new IllegalStateException("Connections=" + factory.getOpenConnectionIds().size() + "wanted=" + n);
    }
}

