/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import org.springframework.integration.aggregator.AggregatingMessageHandler;
import org.springframework.integration.aggregator.DefaultAggregatingMessageGroupProcessor;
import org.springframework.integration.aggregator.ExpressionEvaluatingMessageGroupProcessor;
import org.springframework.integration.aggregator.MessageGroupProcessor;
import org.springframework.integration.aggregator.MethodInvokingMessageGroupProcessor;
import org.springframework.integration.dsl.CorrelationHandlerSpec;

public class AggregatorSpec
extends CorrelationHandlerSpec<AggregatorSpec, AggregatingMessageHandler> {
    private MessageGroupProcessor outputProcessor = new DefaultAggregatingMessageGroupProcessor();
    private boolean expireGroupsUponCompletion;

    AggregatorSpec() {
    }

    @Override
    public AggregatorSpec processor(Object target, String methodName) {
        super.processor(target, methodName);
        return this.outputProcessor((MessageGroupProcessor)(methodName != null ? new MethodInvokingMessageGroupProcessor(target, methodName) : new MethodInvokingMessageGroupProcessor(target)));
    }

    public AggregatorSpec outputExpression(String expression) {
        return this.outputProcessor((MessageGroupProcessor)new ExpressionEvaluatingMessageGroupProcessor(expression));
    }

    public AggregatorSpec outputProcessor(MessageGroupProcessor outputProcessor) {
        this.outputProcessor = outputProcessor;
        return (AggregatorSpec)this._this();
    }

    public AggregatorSpec expireGroupsUponCompletion(boolean expireGroupsUponCompletion) {
        this.expireGroupsUponCompletion = expireGroupsUponCompletion;
        return (AggregatorSpec)this._this();
    }

    @Override
    protected AggregatingMessageHandler doGet() {
        AggregatingMessageHandler handler = new AggregatingMessageHandler(this.outputProcessor);
        handler.setExpireGroupsUponCompletion(this.expireGroupsUponCompletion);
        return this.configure(handler);
    }
}

