/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import java.util.Set;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowDefinition;
import org.springframework.integration.dsl.SourcePollingChannelAdapterSpec;
import org.springframework.integration.dsl.support.FixedSubscriberChannelPrototype;

public final class IntegrationFlowBuilder
extends IntegrationFlowDefinition<IntegrationFlowBuilder> {
    public StandardIntegrationFlow get() {
        if (this.currentMessageChannel instanceof FixedSubscriberChannelPrototype) {
            throw new BeanCreationException("The 'currentMessageChannel' (" + this.currentMessageChannel + ") is a prototype for FixedSubscriberChannel which can't be created without MessageHandler " + "constructor argument. That means that '.fixedSubscriberChannel()' can't be the last EIP-method " + "in the IntegrationFlow definition.");
        }
        if (this.integrationComponents.size() == 1) {
            if (this.currentComponent != null) {
                if (this.currentComponent instanceof SourcePollingChannelAdapterSpec) {
                    throw new BeanCreationException("The 'SourcePollingChannelAdapter' (" + this.currentComponent + ") " + "must be configured with at least one 'MessageChanel' or 'MessageHandler'.");
                }
            } else if (this.currentMessageChannel != null) {
                throw new BeanCreationException("The 'IntegrationFlow' can't consist of only one 'MessageChannel'. Add at lest '.bridge()' EIP-method before the end of flow.");
            }
        }
        return new StandardIntegrationFlow(this.integrationComponents);
    }

    public static final class StandardIntegrationFlow
    implements IntegrationFlow {
        private final Set<Object> integrationComponents;

        StandardIntegrationFlow(Set<Object> integrationComponents) {
            this.integrationComponents = integrationComponents;
        }

        public Set<Object> getIntegrationComponents() {
            return this.integrationComponents;
        }

        @Override
        public void define(IntegrationFlowDefinition<?> flow) {
            throw new UnsupportedOperationException();
        }
    }
}

