/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.expression.MethodFilter;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.integration.aggregator.AbstractCorrelatingMessageHandler;
import org.springframework.integration.aggregator.AggregatingMessageHandler;
import org.springframework.integration.aggregator.ResequencingMessageHandler;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.channel.FixedSubscriberChannel;
import org.springframework.integration.config.ConsumerEndpointFactoryBean;
import org.springframework.integration.config.SourcePollingChannelAdapterFactoryBean;
import org.springframework.integration.core.GenericSelector;
import org.springframework.integration.core.MessageSelector;
import org.springframework.integration.dsl.AggregatorSpec;
import org.springframework.integration.dsl.DelayerEndpointSpec;
import org.springframework.integration.dsl.DslRecipientListRouter;
import org.springframework.integration.dsl.EnricherSpec;
import org.springframework.integration.dsl.FilterEndpointSpec;
import org.springframework.integration.dsl.GatewayEndpointSpec;
import org.springframework.integration.dsl.GenericEndpointSpec;
import org.springframework.integration.dsl.HeaderEnricherSpec;
import org.springframework.integration.dsl.LambdaMessageProcessor;
import org.springframework.integration.dsl.RecipientListRouterSpec;
import org.springframework.integration.dsl.ResequencerSpec;
import org.springframework.integration.dsl.RouterSpec;
import org.springframework.integration.dsl.SourcePollingChannelAdapterSpec;
import org.springframework.integration.dsl.SplitterEndpointSpec;
import org.springframework.integration.dsl.channel.MessageChannelSpec;
import org.springframework.integration.dsl.core.ConsumerEndpointSpec;
import org.springframework.integration.dsl.core.MessageHandlerSpec;
import org.springframework.integration.dsl.support.BeanNameMessageProcessor;
import org.springframework.integration.dsl.support.ComponentConfigurer;
import org.springframework.integration.dsl.support.EndpointConfigurer;
import org.springframework.integration.dsl.support.FixedSubscriberChannelPrototype;
import org.springframework.integration.dsl.support.GenericHandler;
import org.springframework.integration.dsl.support.GenericRouter;
import org.springframework.integration.dsl.support.GenericSplitter;
import org.springframework.integration.dsl.support.MapBuilder;
import org.springframework.integration.dsl.support.MessageChannelReference;
import org.springframework.integration.dsl.tuple.Tuple2;
import org.springframework.integration.expression.ControlBusMethodFilter;
import org.springframework.integration.filter.ExpressionEvaluatingSelector;
import org.springframework.integration.filter.MessageFilter;
import org.springframework.integration.filter.MethodInvokingSelector;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.handler.BridgeHandler;
import org.springframework.integration.handler.DelayHandler;
import org.springframework.integration.handler.ExpressionCommandMessageProcessor;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.integration.handler.ServiceActivatingHandler;
import org.springframework.integration.router.AbstractMappingMessageRouter;
import org.springframework.integration.router.AbstractMessageRouter;
import org.springframework.integration.router.ExpressionEvaluatingRouter;
import org.springframework.integration.router.MethodInvokingRouter;
import org.springframework.integration.router.RecipientListRouter;
import org.springframework.integration.splitter.AbstractMessageSplitter;
import org.springframework.integration.splitter.DefaultMessageSplitter;
import org.springframework.integration.splitter.ExpressionEvaluatingSplitter;
import org.springframework.integration.splitter.MethodInvokingSplitter;
import org.springframework.integration.store.MessageStore;
import org.springframework.integration.transformer.ClaimCheckInTransformer;
import org.springframework.integration.transformer.ClaimCheckOutTransformer;
import org.springframework.integration.transformer.ContentEnricher;
import org.springframework.integration.transformer.ExpressionEvaluatingTransformer;
import org.springframework.integration.transformer.GenericTransformer;
import org.springframework.integration.transformer.HeaderFilter;
import org.springframework.integration.transformer.MessageTransformingHandler;
import org.springframework.integration.transformer.MethodInvokingTransformer;
import org.springframework.integration.transformer.Transformer;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class IntegrationFlowDefinition<B extends IntegrationFlowDefinition<B>> {
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();
    protected final Set<Object> integrationComponents = new LinkedHashSet<Object>();
    protected MessageChannel currentMessageChannel;
    protected Object currentComponent;

    IntegrationFlowDefinition() {
    }

    B addComponent(Object component) {
        this.integrationComponents.add(component);
        return this._this();
    }

    B addComponents(Collection<Object> components) {
        if (components != null) {
            for (Object component : components) {
                this.integrationComponents.add(component);
            }
        }
        return this._this();
    }

    B currentComponent(Object component) {
        this.currentComponent = component;
        return this._this();
    }

    public B fixedSubscriberChannel() {
        return this.fixedSubscriberChannel(null);
    }

    public B fixedSubscriberChannel(String messageChannelName) {
        return this.channel(new FixedSubscriberChannelPrototype(messageChannelName));
    }

    public B channel(String messageChannelName) {
        return this.channel(new MessageChannelReference(messageChannelName));
    }

    public B channel(MessageChannel messageChannel) {
        Assert.notNull((Object)messageChannel);
        if (this.currentMessageChannel != null) {
            this.register(new GenericEndpointSpec<BridgeHandler>(new BridgeHandler()), null);
        }
        this.currentMessageChannel = messageChannel;
        return this.registerOutputChannelIfCan(this.currentMessageChannel);
    }

    public B channel(MessageChannelSpec<?, ?> messageChannelSpec) {
        Assert.notNull(messageChannelSpec);
        return this.channel((MessageChannel)messageChannelSpec.get());
    }

    public B controlBus() {
        return this.controlBus(null);
    }

    public B controlBus(EndpointConfigurer<GenericEndpointSpec<ServiceActivatingHandler>> endpointConfigurer) {
        return this.handle(new ServiceActivatingHandler((MessageProcessor)new ExpressionCommandMessageProcessor((MethodFilter)new ControlBusMethodFilter())), endpointConfigurer);
    }

    public B transform(String expression) {
        Assert.hasText((String)expression);
        return this.transform((GenericTransformer)new ExpressionEvaluatingTransformer(PARSER.parseExpression(expression)));
    }

    public <S, T> B transform(GenericTransformer<S, T> genericTransformer) {
        return this.transform(null, genericTransformer);
    }

    public <P, T> B transform(Class<P> payloadType, GenericTransformer<P, T> genericTransformer) {
        return this.transform(payloadType, genericTransformer, null);
    }

    public <S, T> B transform(GenericTransformer<S, T> genericTransformer, EndpointConfigurer<GenericEndpointSpec<MessageTransformingHandler>> endpointConfigurer) {
        return this.transform(null, genericTransformer, endpointConfigurer);
    }

    public <P, T> B transform(Class<P> payloadType, GenericTransformer<P, T> genericTransformer, EndpointConfigurer<GenericEndpointSpec<MessageTransformingHandler>> endpointConfigurer) {
        Assert.notNull(genericTransformer);
        Transformer transformer = genericTransformer instanceof Transformer ? (Transformer)genericTransformer : (IntegrationFlowDefinition.isLambda(genericTransformer) ? new MethodInvokingTransformer((Object)new LambdaMessageProcessor(genericTransformer, payloadType)) : new MethodInvokingTransformer(genericTransformer));
        return ((IntegrationFlowDefinition)this.addComponent(transformer)).handle((MessageTransformingHandler)new MessageTransformingHandler(transformer), endpointConfigurer);
    }

    public B filter(String expression) {
        Assert.hasText((String)expression);
        return this.filter((GenericSelector)new ExpressionEvaluatingSelector(PARSER.parseExpression(expression)));
    }

    public <S> B filter(GenericSelector<S> genericSelector) {
        return this.filter(null, genericSelector);
    }

    public <P> B filter(Class<P> payloadType, GenericSelector<P> genericSelector) {
        return this.filter(payloadType, genericSelector, null);
    }

    public <P> B filter(GenericSelector<P> genericSelector, EndpointConfigurer<FilterEndpointSpec> endpointConfigurer) {
        return this.filter(null, genericSelector, endpointConfigurer);
    }

    public <P> B filter(Class<P> payloadType, GenericSelector<P> genericSelector, EndpointConfigurer<FilterEndpointSpec> endpointConfigurer) {
        Assert.notNull(genericSelector);
        MessageSelector selector = genericSelector instanceof MessageSelector ? (MessageSelector)genericSelector : (IntegrationFlowDefinition.isLambda(genericSelector) ? new MethodInvokingSelector((Object)new LambdaMessageProcessor(genericSelector, payloadType)) : new MethodInvokingSelector(genericSelector));
        return this.register(new FilterEndpointSpec(new MessageFilter(selector)), endpointConfigurer);
    }

    public <S extends MessageHandlerSpec<S, ? extends MessageHandler>> B handle(S messageHandlerSpec) {
        Assert.notNull(messageHandlerSpec);
        return this.handle((MessageHandler)messageHandlerSpec.get());
    }

    public B handle(MessageHandler messageHandler) {
        return this.handle(messageHandler, null);
    }

    public B handle(String beanName, String methodName) {
        return this.handle(beanName, methodName, null);
    }

    public B handle(String beanName, String methodName, EndpointConfigurer<GenericEndpointSpec<ServiceActivatingHandler>> endpointConfigurer) {
        return this.handle(new ServiceActivatingHandler(new BeanNameMessageProcessor(beanName, methodName)), endpointConfigurer);
    }

    public <P> B handle(GenericHandler<P> handler) {
        return this.handle(null, handler);
    }

    public <P> B handle(GenericHandler<P> handler, EndpointConfigurer<GenericEndpointSpec<ServiceActivatingHandler>> endpointConfigurer) {
        return this.handle(null, handler, endpointConfigurer);
    }

    public <P> B handle(Class<P> payloadType, GenericHandler<P> handler) {
        return this.handle(payloadType, handler, null);
    }

    public <P> B handle(Class<P> payloadType, GenericHandler<P> handler, EndpointConfigurer<GenericEndpointSpec<ServiceActivatingHandler>> endpointConfigurer) {
        ServiceActivatingHandler serviceActivatingHandler = null;
        serviceActivatingHandler = IntegrationFlowDefinition.isLambda(handler) ? new ServiceActivatingHandler((MessageProcessor)new LambdaMessageProcessor(handler, payloadType)) : new ServiceActivatingHandler(handler);
        return this.handle(serviceActivatingHandler, endpointConfigurer);
    }

    public <H extends MessageHandler, S extends MessageHandlerSpec<S, H>> B handle(S messageHandlerSpec, EndpointConfigurer<GenericEndpointSpec<H>> endpointConfigurer) {
        Assert.notNull(messageHandlerSpec);
        return this.handle((MessageHandler)messageHandlerSpec.get(), endpointConfigurer);
    }

    public <H extends MessageHandler> B handle(H messageHandler, EndpointConfigurer<GenericEndpointSpec<H>> endpointConfigurer) {
        Assert.notNull(messageHandler);
        return this.register(new GenericEndpointSpec<H>(messageHandler), endpointConfigurer);
    }

    public B bridge(EndpointConfigurer<GenericEndpointSpec<BridgeHandler>> endpointConfigurer) {
        return this.register(new GenericEndpointSpec<BridgeHandler>(new BridgeHandler()), endpointConfigurer);
    }

    public B delay(String groupId, String expression) {
        return this.delay(groupId, expression, null);
    }

    public B delay(String groupId, String expression, EndpointConfigurer<DelayerEndpointSpec> endpointConfigurer) {
        DelayHandler delayHandler = new DelayHandler(groupId);
        if (StringUtils.hasText((String)expression)) {
            delayHandler.setDelayExpression(PARSER.parseExpression(expression));
        }
        return this.register(new DelayerEndpointSpec(delayHandler), endpointConfigurer);
    }

    public B enrich(ComponentConfigurer<EnricherSpec> enricherConfigurer) {
        return this.enrich(enricherConfigurer, null);
    }

    public B enrich(ComponentConfigurer<EnricherSpec> enricherConfigurer, EndpointConfigurer<GenericEndpointSpec<ContentEnricher>> endpointConfigurer) {
        Assert.notNull(enricherConfigurer);
        EnricherSpec enricherSpec = new EnricherSpec();
        enricherConfigurer.configure(enricherSpec);
        return this.handle((MessageHandler)enricherSpec.get(), endpointConfigurer);
    }

    public B enrichHeaders(MapBuilder<?, String, Object> headers) {
        return this.enrichHeaders(headers, null);
    }

    public B enrichHeaders(MapBuilder<?, String, Object> headers, EndpointConfigurer<GenericEndpointSpec<MessageTransformingHandler>> endpointConfigurer) {
        return this.enrichHeaders(headers.get(), endpointConfigurer);
    }

    public B enrichHeaders(Map<String, Object> headers) {
        return this.enrichHeaders(headers, null);
    }

    public B enrichHeaders(final Map<String, Object> headers, EndpointConfigurer<GenericEndpointSpec<MessageTransformingHandler>> endpointConfigurer) {
        return this.enrichHeaders(new ComponentConfigurer<HeaderEnricherSpec>(){

            @Override
            public void configure(HeaderEnricherSpec spec) {
                spec.headers(headers);
            }
        }, endpointConfigurer);
    }

    public B enrichHeaders(ComponentConfigurer<HeaderEnricherSpec> headerEnricherConfigurer) {
        return this.enrichHeaders(headerEnricherConfigurer, null);
    }

    public B enrichHeaders(ComponentConfigurer<HeaderEnricherSpec> headerEnricherConfigurer, EndpointConfigurer<GenericEndpointSpec<MessageTransformingHandler>> endpointConfigurer) {
        Assert.notNull(headerEnricherConfigurer);
        HeaderEnricherSpec headerEnricherSpec = new HeaderEnricherSpec();
        headerEnricherConfigurer.configure(headerEnricherSpec);
        return this.transform((GenericTransformer)headerEnricherSpec.get(), endpointConfigurer);
    }

    public B split(EndpointConfigurer<SplitterEndpointSpec<DefaultMessageSplitter>> endpointConfigurer) {
        return this.split(new DefaultMessageSplitter(), endpointConfigurer);
    }

    public B split(String expression, EndpointConfigurer<SplitterEndpointSpec<ExpressionEvaluatingSplitter>> endpointConfigurer) {
        return this.split(new ExpressionEvaluatingSplitter(PARSER.parseExpression(expression)), endpointConfigurer);
    }

    public B split(String beanName, String methodName) {
        return this.split(beanName, methodName, null);
    }

    public B split(String beanName, String methodName, EndpointConfigurer<SplitterEndpointSpec<MethodInvokingSplitter>> endpointConfigurer) {
        return this.split(new MethodInvokingSplitter(new BeanNameMessageProcessor(beanName, methodName)), endpointConfigurer);
    }

    public <P> B split(Class<P> payloadType, GenericSplitter<P> splitter) {
        return this.split(payloadType, splitter, null);
    }

    public <T> B split(GenericSplitter<T> splitter, EndpointConfigurer<SplitterEndpointSpec<MethodInvokingSplitter>> endpointConfigurer) {
        return this.split(null, splitter, endpointConfigurer);
    }

    public <P> B split(Class<P> payloadType, GenericSplitter<P> splitter, EndpointConfigurer<SplitterEndpointSpec<MethodInvokingSplitter>> endpointConfigurer) {
        MethodInvokingSplitter split = IntegrationFlowDefinition.isLambda(splitter) ? new MethodInvokingSplitter((Object)new LambdaMessageProcessor(splitter, payloadType)) : new MethodInvokingSplitter(splitter, "split");
        return this.split(split, endpointConfigurer);
    }

    public <S extends AbstractMessageSplitter> B split(S splitter, EndpointConfigurer<SplitterEndpointSpec<S>> endpointConfigurer) {
        Assert.notNull(splitter);
        return this.register(new SplitterEndpointSpec<S>(splitter), endpointConfigurer);
    }

    public B headerFilter(String ... headersToRemove) {
        return this.headerFilter(new HeaderFilter(headersToRemove), null);
    }

    public B headerFilter(String headersToRemove, boolean patternMatch) {
        HeaderFilter headerFilter = new HeaderFilter(StringUtils.delimitedListToStringArray((String)headersToRemove, (String)",", (String)" "));
        headerFilter.setPatternMatch(patternMatch);
        return this.headerFilter(headerFilter, null);
    }

    public B headerFilter(HeaderFilter headerFilter, EndpointConfigurer<GenericEndpointSpec<MessageTransformingHandler>> endpointConfigurer) {
        return this.transform((GenericTransformer)headerFilter, endpointConfigurer);
    }

    public B claimCheckIn(MessageStore messageStore) {
        return this.claimCheckIn(messageStore, null);
    }

    public B claimCheckIn(MessageStore messageStore, EndpointConfigurer<GenericEndpointSpec<MessageTransformingHandler>> endpointConfigurer) {
        return this.transform((GenericTransformer)new ClaimCheckInTransformer(messageStore), endpointConfigurer);
    }

    public B claimCheckOut(MessageStore messageStore) {
        return this.claimCheckOut(messageStore, false);
    }

    public B claimCheckOut(MessageStore messageStore, boolean removeMessage) {
        return this.claimCheckOut(messageStore, removeMessage, null);
    }

    public B claimCheckOut(MessageStore messageStore, boolean removeMessage, EndpointConfigurer<GenericEndpointSpec<MessageTransformingHandler>> endpointConfigurer) {
        ClaimCheckOutTransformer claimCheckOutTransformer = new ClaimCheckOutTransformer(messageStore);
        claimCheckOutTransformer.setRemoveMessage(removeMessage);
        return this.transform((GenericTransformer)claimCheckOutTransformer, endpointConfigurer);
    }

    public B resequence() {
        return this.resequence(null);
    }

    public B resequence(EndpointConfigurer<GenericEndpointSpec<ResequencingMessageHandler>> endpointConfigurer) {
        return this.handle((MessageHandler)new ResequencerSpec().get(), endpointConfigurer);
    }

    public B resequence(ComponentConfigurer<ResequencerSpec> resequencerConfigurer, EndpointConfigurer<GenericEndpointSpec<ResequencingMessageHandler>> endpointConfigurer) {
        Assert.notNull(resequencerConfigurer);
        ResequencerSpec spec = new ResequencerSpec();
        resequencerConfigurer.configure(spec);
        return this.handle((MessageHandler)spec.get(), endpointConfigurer);
    }

    public B aggregate() {
        return this.aggregate(null);
    }

    public B aggregate(EndpointConfigurer<GenericEndpointSpec<AggregatingMessageHandler>> endpointConfigurer) {
        return this.handle((MessageHandler)new AggregatorSpec().get(), endpointConfigurer);
    }

    public B aggregate(ComponentConfigurer<AggregatorSpec> aggregatorConfigurer, EndpointConfigurer<GenericEndpointSpec<AggregatingMessageHandler>> endpointConfigurer) {
        Assert.notNull(aggregatorConfigurer);
        AggregatorSpec spec = new AggregatorSpec();
        aggregatorConfigurer.configure(spec);
        return this.handle((MessageHandler)spec.get(), endpointConfigurer);
    }

    public B route(String beanName, String method) {
        return this.route(beanName, method, null);
    }

    public B route(String beanName, String method, ComponentConfigurer<RouterSpec<MethodInvokingRouter>> routerConfigurer) {
        return this.route(beanName, method, routerConfigurer, null);
    }

    public B route(String beanName, String method, ComponentConfigurer<RouterSpec<MethodInvokingRouter>> routerConfigurer, EndpointConfigurer<GenericEndpointSpec<MethodInvokingRouter>> endpointConfigurer) {
        return this.route(new MethodInvokingRouter(new BeanNameMessageProcessor(beanName, method)), routerConfigurer, endpointConfigurer);
    }

    public B route(String expression) {
        return this.route(expression, (ComponentConfigurer<RouterSpec<ExpressionEvaluatingRouter>>)null);
    }

    public B route(String expression, ComponentConfigurer<RouterSpec<ExpressionEvaluatingRouter>> routerConfigurer) {
        return this.route((AbstractMappingMessageRouter)expression, routerConfigurer, null);
    }

    public B route(String expression, ComponentConfigurer<RouterSpec<ExpressionEvaluatingRouter>> routerConfigurer, EndpointConfigurer<GenericEndpointSpec<ExpressionEvaluatingRouter>> endpointConfigurer) {
        return this.route(new ExpressionEvaluatingRouter(PARSER.parseExpression(expression)), routerConfigurer, endpointConfigurer);
    }

    public <S, T> B route(GenericRouter<S, T> router) {
        return this.route(null, router);
    }

    public <S, T> B route(GenericRouter<S, T> router, ComponentConfigurer<RouterSpec<MethodInvokingRouter>> routerConfigurer) {
        return this.route(null, router, routerConfigurer);
    }

    public <P, T> B route(Class<P> payloadType, GenericRouter<P, T> router) {
        return this.route(payloadType, router, null, null);
    }

    public <P, T> B route(Class<P> payloadType, GenericRouter<P, T> router, ComponentConfigurer<RouterSpec<MethodInvokingRouter>> routerConfigurer) {
        return this.route(payloadType, router, routerConfigurer, null);
    }

    public <S, T> B route(GenericRouter<S, T> router, ComponentConfigurer<RouterSpec<MethodInvokingRouter>> routerConfigurer, EndpointConfigurer<GenericEndpointSpec<MethodInvokingRouter>> endpointConfigurer) {
        return this.route(null, router, routerConfigurer, endpointConfigurer);
    }

    public <P, T> B route(Class<P> payloadType, GenericRouter<P, T> router, ComponentConfigurer<RouterSpec<MethodInvokingRouter>> routerConfigurer, EndpointConfigurer<GenericEndpointSpec<MethodInvokingRouter>> endpointConfigurer) {
        MethodInvokingRouter methodInvokingRouter = IntegrationFlowDefinition.isLambda(router) ? new MethodInvokingRouter((Object)new LambdaMessageProcessor(router, payloadType)) : new MethodInvokingRouter(router);
        return this.route(methodInvokingRouter, routerConfigurer, endpointConfigurer);
    }

    public <R extends AbstractMappingMessageRouter> B route(R router, ComponentConfigurer<RouterSpec<R>> routerConfigurer, EndpointConfigurer<GenericEndpointSpec<R>> endpointConfigurer) {
        if (routerConfigurer != null) {
            RouterSpec<R> routerSpec = new RouterSpec<R>(router);
            routerConfigurer.configure(routerSpec);
        }
        return this.route(router, endpointConfigurer);
    }

    public B routeToRecipients(ComponentConfigurer<RecipientListRouterSpec> routerConfigurer) {
        return this.routeToRecipients(routerConfigurer, null);
    }

    public B routeToRecipients(ComponentConfigurer<RecipientListRouterSpec> routerConfigurer, EndpointConfigurer<GenericEndpointSpec<RecipientListRouter>> endpointConfigurer) {
        Assert.notNull(routerConfigurer);
        RecipientListRouterSpec spec = new RecipientListRouterSpec();
        routerConfigurer.configure(spec);
        DslRecipientListRouter recipientListRouter = (DslRecipientListRouter)((Object)spec.get());
        Assert.notEmpty(recipientListRouter.get(), (String)"recipient list must not be empty");
        return this.route(recipientListRouter, endpointConfigurer);
    }

    public B route(AbstractMessageRouter router) {
        return this.route(router, null);
    }

    public <R extends AbstractMessageRouter> B route(R router, EndpointConfigurer<GenericEndpointSpec<R>> endpointConfigurer) {
        return this.handle((MessageHandler)router, endpointConfigurer);
    }

    public B gateway(String requestChannel) {
        return this.gateway(requestChannel, null);
    }

    public B gateway(String requestChannel, EndpointConfigurer<GatewayEndpointSpec> endpointConfigurer) {
        return this.register(new GatewayEndpointSpec(requestChannel), endpointConfigurer);
    }

    public B gateway(MessageChannel requestChannel) {
        return this.gateway(requestChannel, null);
    }

    public B gateway(MessageChannel requestChannel, EndpointConfigurer<GatewayEndpointSpec> endpointConfigurer) {
        return this.register(new GatewayEndpointSpec(requestChannel), endpointConfigurer);
    }

    private <S extends ConsumerEndpointSpec<S, ?>> B register(S endpointSpec, EndpointConfigurer<S> endpointConfigurer) {
        if (endpointConfigurer != null) {
            endpointConfigurer.configure(endpointSpec);
        }
        MessageChannel inputChannel = this.currentMessageChannel;
        this.currentMessageChannel = null;
        if (inputChannel == null) {
            inputChannel = new DirectChannel();
            this.registerOutputChannelIfCan(inputChannel);
        }
        if (inputChannel instanceof MessageChannelReference) {
            ((ConsumerEndpointFactoryBean)((Tuple2)endpointSpec.get()).getT1()).setInputChannelName(((MessageChannelReference)inputChannel).getName());
        } else {
            if (inputChannel instanceof FixedSubscriberChannelPrototype) {
                String beanName = ((FixedSubscriberChannelPrototype)inputChannel).getName();
                inputChannel = new FixedSubscriberChannel((MessageHandler)((Tuple2)endpointSpec.get()).getT2());
                if (beanName != null) {
                    ((FixedSubscriberChannel)inputChannel).setBeanName(beanName);
                }
                this.registerOutputChannelIfCan(inputChannel);
            }
            ((ConsumerEndpointFactoryBean)((Tuple2)endpointSpec.get()).getT1()).setInputChannel(inputChannel);
        }
        return ((IntegrationFlowDefinition)this.addComponent(endpointSpec)).currentComponent(((Tuple2)endpointSpec.get()).getT2());
    }

    private B registerOutputChannelIfCan(MessageChannel outputChannel) {
        if (!(outputChannel instanceof FixedSubscriberChannelPrototype)) {
            this.integrationComponents.add(outputChannel);
            if (this.currentComponent != null) {
                Object currentComponent;
                String channelName = null;
                if (outputChannel instanceof MessageChannelReference) {
                    channelName = ((MessageChannelReference)outputChannel).getName();
                }
                if (AopUtils.isAopProxy((Object)(currentComponent = this.currentComponent))) {
                    currentComponent = IntegrationFlowDefinition.extractProxyTarget(currentComponent);
                }
                if (currentComponent instanceof AbstractReplyProducingMessageHandler) {
                    AbstractReplyProducingMessageHandler messageProducer = (AbstractReplyProducingMessageHandler)currentComponent;
                    if (channelName != null) {
                        messageProducer.setOutputChannelName(channelName);
                    } else {
                        messageProducer.setOutputChannel(outputChannel);
                    }
                } else if (currentComponent instanceof SourcePollingChannelAdapterSpec) {
                    SourcePollingChannelAdapterFactoryBean pollingChannelAdapterFactoryBean = (SourcePollingChannelAdapterFactoryBean)((Tuple2)((SourcePollingChannelAdapterSpec)currentComponent).get()).getT1();
                    if (channelName != null) {
                        pollingChannelAdapterFactoryBean.setOutputChannelName(channelName);
                    } else {
                        pollingChannelAdapterFactoryBean.setOutputChannel(outputChannel);
                    }
                } else if (currentComponent instanceof AbstractCorrelatingMessageHandler) {
                    AbstractCorrelatingMessageHandler messageProducer = (AbstractCorrelatingMessageHandler)currentComponent;
                    if (channelName != null) {
                        messageProducer.setOutputChannelName(channelName);
                    } else {
                        messageProducer.setOutputChannel(outputChannel);
                    }
                } else if (this.currentComponent instanceof AbstractMessageRouter) {
                    AbstractMessageRouter router = (AbstractMessageRouter)this.currentComponent;
                    if (channelName != null) {
                        router.setDefaultOutputChannelName(channelName);
                    } else {
                        router.setDefaultOutputChannel(outputChannel);
                    }
                } else {
                    throw new BeanCreationException("The 'currentComponent' (" + currentComponent + ") is a one-way 'MessageHandler' and it isn't appropriate to configure 'outputChannel'. " + "This is the end of the integration flow.");
                }
                this.currentComponent = null;
            }
        }
        return this._this();
    }

    protected final B _this() {
        return (B)this;
    }

    private static boolean isLambda(Object o) {
        Class<?> aClass = o.getClass();
        return aClass.isSynthetic() && !aClass.isAnonymousClass() && !aClass.isLocalClass();
    }

    private static Object extractProxyTarget(Object target) {
        if (!(target instanceof Advised)) {
            return target;
        }
        Advised advised = (Advised)target;
        if (advised.getTargetSource() == null) {
            return null;
        }
        try {
            return IntegrationFlowDefinition.extractProxyTarget(advised.getTargetSource().getTarget());
        }
        catch (Exception e) {
            throw new BeanCreationException("Could not extract target", (Throwable)e);
        }
    }
}

