/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import org.springframework.beans.DirectFieldAccessor;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.SourcePollingChannelAdapterSpec;
import org.springframework.integration.dsl.channel.MessageChannelSpec;
import org.springframework.integration.dsl.core.ComponentsRegistration;
import org.springframework.integration.dsl.core.MessageProducerSpec;
import org.springframework.integration.dsl.core.MessageSourceSpec;
import org.springframework.integration.dsl.core.MessagingGatewaySpec;
import org.springframework.integration.dsl.support.EndpointConfigurer;
import org.springframework.integration.dsl.support.FixedSubscriberChannelPrototype;
import org.springframework.integration.dsl.support.MessageChannelReference;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.gateway.MessagingGatewaySupport;
import org.springframework.messaging.MessageChannel;

public final class IntegrationFlows {
    public static IntegrationFlowBuilder from(String messageChannelName) {
        return IntegrationFlows.from(new MessageChannelReference(messageChannelName));
    }

    public static IntegrationFlowBuilder fromFixedMessageChannel(String messageChannelName) {
        return IntegrationFlows.from(new FixedSubscriberChannelPrototype(messageChannelName));
    }

    public static IntegrationFlowBuilder from(MessageChannelSpec<?, ?> messageChannelSpec) {
        return IntegrationFlows.from((MessageChannel)messageChannelSpec.get());
    }

    public static IntegrationFlowBuilder from(MessageChannel messageChannel) {
        return (IntegrationFlowBuilder)new IntegrationFlowBuilder().channel(messageChannel);
    }

    public static <S extends MessageSourceSpec<S, ? extends MessageSource<?>>> IntegrationFlowBuilder from(S messageSourceSpec) {
        return IntegrationFlows.from(messageSourceSpec, null);
    }

    public static <S extends MessageSourceSpec<S, ? extends MessageSource<?>>> IntegrationFlowBuilder from(S messageSourceSpec, EndpointConfigurer<SourcePollingChannelAdapterSpec> endpointConfigurer) {
        return IntegrationFlows.from((MessageSource)messageSourceSpec.get(), endpointConfigurer, IntegrationFlows.registerComponents(messageSourceSpec));
    }

    public static IntegrationFlowBuilder from(MessageSource<?> messageSource) {
        return IntegrationFlows.from(messageSource, null);
    }

    public static IntegrationFlowBuilder from(MessageSource<?> messageSource, EndpointConfigurer<SourcePollingChannelAdapterSpec> endpointConfigurer) {
        return IntegrationFlows.from(messageSource, endpointConfigurer, null);
    }

    private static IntegrationFlowBuilder from(MessageSource<?> messageSource, EndpointConfigurer<SourcePollingChannelAdapterSpec> endpointConfigurer, IntegrationFlowBuilder integrationFlowBuilder) {
        SourcePollingChannelAdapterSpec spec = new SourcePollingChannelAdapterSpec(messageSource);
        if (endpointConfigurer != null) {
            endpointConfigurer.configure(spec);
        }
        if (integrationFlowBuilder == null) {
            integrationFlowBuilder = new IntegrationFlowBuilder();
        }
        return (IntegrationFlowBuilder)((IntegrationFlowBuilder)integrationFlowBuilder.addComponent(spec)).currentComponent(spec);
    }

    public static IntegrationFlowBuilder from(MessageProducerSpec<?, ?> messageProducerSpec) {
        return IntegrationFlows.from((MessageProducerSupport)messageProducerSpec.get(), IntegrationFlows.registerComponents(messageProducerSpec));
    }

    public static IntegrationFlowBuilder from(MessageProducerSupport messageProducer) {
        return IntegrationFlows.from(messageProducer, null);
    }

    private static IntegrationFlowBuilder from(MessageProducerSupport messageProducer, IntegrationFlowBuilder integrationFlowBuilder) {
        DirectFieldAccessor dfa = new DirectFieldAccessor((Object)messageProducer);
        MessageChannel outputChannel = (MessageChannel)dfa.getPropertyValue("outputChannel");
        if (outputChannel == null) {
            outputChannel = new DirectChannel();
            messageProducer.setOutputChannel(outputChannel);
        }
        if (integrationFlowBuilder == null) {
            integrationFlowBuilder = IntegrationFlows.from(outputChannel);
        } else {
            integrationFlowBuilder.channel(outputChannel);
        }
        return (IntegrationFlowBuilder)integrationFlowBuilder.addComponent(messageProducer);
    }

    public static IntegrationFlowBuilder from(MessagingGatewaySpec<?, ?> inboundGatewaySpec) {
        return IntegrationFlows.from((MessagingGatewaySupport)inboundGatewaySpec.get(), IntegrationFlows.registerComponents(inboundGatewaySpec));
    }

    public static IntegrationFlowBuilder from(MessagingGatewaySupport inboundGateway) {
        DirectFieldAccessor dfa = new DirectFieldAccessor((Object)inboundGateway);
        MessageChannel outputChannel = (MessageChannel)dfa.getPropertyValue("requestChannel");
        if (outputChannel == null) {
            outputChannel = new DirectChannel();
            inboundGateway.setRequestChannel(outputChannel);
        }
        return (IntegrationFlowBuilder)IntegrationFlows.from(outputChannel).addComponent(inboundGateway);
    }

    private static IntegrationFlowBuilder from(MessagingGatewaySupport inboundGateway, IntegrationFlowBuilder integrationFlowBuilder) {
        DirectFieldAccessor dfa = new DirectFieldAccessor((Object)inboundGateway);
        MessageChannel outputChannel = (MessageChannel)dfa.getPropertyValue("requestChannel");
        if (outputChannel == null) {
            outputChannel = new DirectChannel();
            inboundGateway.setRequestChannel(outputChannel);
        }
        if (integrationFlowBuilder == null) {
            integrationFlowBuilder = IntegrationFlows.from(outputChannel);
        } else {
            integrationFlowBuilder.channel(outputChannel);
        }
        return (IntegrationFlowBuilder)integrationFlowBuilder.addComponent(inboundGateway);
    }

    private static IntegrationFlowBuilder registerComponents(Object spec) {
        if (spec instanceof ComponentsRegistration) {
            return (IntegrationFlowBuilder)new IntegrationFlowBuilder().addComponents(((ComponentsRegistration)spec).getComponentsToRegister());
        }
        return null;
    }

    private IntegrationFlows() {
    }
}

