/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.mail;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.mail.Authenticator;
import javax.mail.Session;
import org.aopalliance.aop.Advice;
import org.springframework.integration.dsl.core.ComponentsRegistration;
import org.springframework.integration.dsl.core.MessageProducerSpec;
import org.springframework.integration.dsl.support.PropertiesBuilder;
import org.springframework.integration.mail.ImapIdleChannelAdapter;
import org.springframework.integration.mail.ImapMailReceiver;
import org.springframework.integration.mail.SearchTermStrategy;
import org.springframework.integration.transaction.TransactionSynchronizationFactory;

public class ImapIdleChannelAdapterSpec
extends MessageProducerSpec<ImapIdleChannelAdapterSpec, ImapIdleChannelAdapter>
implements ComponentsRegistration {
    private final ImapMailReceiver receiver;

    ImapIdleChannelAdapterSpec(ImapMailReceiver receiver) {
        super(new ImapIdleChannelAdapter(receiver));
        this.receiver = receiver;
    }

    public ImapIdleChannelAdapterSpec selectorExpression(String selectorExpression) {
        this.receiver.setSelectorExpression(PARSER.parseExpression(selectorExpression));
        return this;
    }

    public ImapIdleChannelAdapterSpec session(Session session) {
        this.receiver.setSession(session);
        return this;
    }

    public ImapIdleChannelAdapterSpec javaMailProperties(Properties javaMailProperties) {
        this.receiver.setJavaMailProperties(javaMailProperties);
        return this;
    }

    public ImapIdleChannelAdapterSpec javaMailProperties(PropertiesBuilder.PropertiesConfigurer configurer) {
        PropertiesBuilder properties = new PropertiesBuilder();
        configurer.configure(properties);
        return this.javaMailProperties(properties.get());
    }

    public ImapIdleChannelAdapterSpec javaMailAuthenticator(Authenticator javaMailAuthenticator) {
        this.receiver.setJavaMailAuthenticator(javaMailAuthenticator);
        return this;
    }

    public ImapIdleChannelAdapterSpec maxFetchSize(int maxFetchSize) {
        this.receiver.setMaxFetchSize(maxFetchSize);
        return this;
    }

    public ImapIdleChannelAdapterSpec shouldDeleteMessages(boolean shouldDeleteMessages) {
        this.receiver.setShouldDeleteMessages(shouldDeleteMessages);
        return this;
    }

    public ImapIdleChannelAdapterSpec searchTermStrategy(SearchTermStrategy searchTermStrategy) {
        this.receiver.setSearchTermStrategy(searchTermStrategy);
        return this;
    }

    public ImapIdleChannelAdapterSpec shouldMarkMessagesAsRead(boolean shouldMarkMessagesAsRead) {
        this.receiver.setShouldMarkMessagesAsRead(Boolean.valueOf(shouldMarkMessagesAsRead));
        return this;
    }

    public ImapIdleChannelAdapterSpec transactionSynchronizationFactory(TransactionSynchronizationFactory transactionSynchronizationFactory) {
        ((ImapIdleChannelAdapter)this.target).setTransactionSynchronizationFactory(transactionSynchronizationFactory);
        return this;
    }

    public ImapIdleChannelAdapterSpec adviceChain(Advice ... adviceChain) {
        ((ImapIdleChannelAdapter)this.target).setAdviceChain(Arrays.asList(adviceChain));
        return this;
    }

    public ImapIdleChannelAdapterSpec sendingTaskExecutor(Executor sendingTaskExecutor) {
        ((ImapIdleChannelAdapter)this.target).setSendingTaskExecutor(sendingTaskExecutor);
        return this;
    }

    public ImapIdleChannelAdapterSpec shouldReconnectAutomatically(boolean shouldReconnectAutomatically) {
        ((ImapIdleChannelAdapter)this.target).setShouldReconnectAutomatically(shouldReconnectAutomatically);
        return this;
    }

    @Override
    public Collection<Object> getComponentsToRegister() {
        return Collections.singletonList(this.receiver);
    }
}

