/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.core.MessageSelector;
import org.springframework.integration.dsl.AbstractRouterSpec;
import org.springframework.integration.dsl.DslRecipientListRouter;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.IntegrationFlows;
import org.springframework.integration.dsl.core.ComponentsRegistration;
import org.springframework.integration.router.RecipientListRouter;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.Assert;

public class RecipientListRouterSpec
extends AbstractRouterSpec<RecipientListRouterSpec, RecipientListRouter>
implements ComponentsRegistration {
    private final List<Object> subFlows = new ArrayList<Object>();

    RecipientListRouterSpec() {
        super(new DslRecipientListRouter());
    }

    public RecipientListRouterSpec recipient(String channelName) {
        Assert.hasText((String)channelName);
        ((DslRecipientListRouter)((Object)this.target)).add(channelName, (MessageSelector)null);
        return (RecipientListRouterSpec)this._this();
    }

    public RecipientListRouterSpec recipient(String channelName, String expression) {
        Assert.hasText((String)channelName);
        ((DslRecipientListRouter)((Object)this.target)).add(channelName, expression);
        return (RecipientListRouterSpec)this._this();
    }

    public RecipientListRouterSpec recipient(String channelName, MessageSelector selector) {
        Assert.hasText((String)channelName);
        ((DslRecipientListRouter)((Object)this.target)).add(channelName, selector);
        return (RecipientListRouterSpec)this._this();
    }

    public RecipientListRouterSpec recipient(MessageChannel channel) {
        Assert.notNull((Object)channel);
        ((DslRecipientListRouter)((Object)this.target)).add(channel, (MessageSelector)null);
        return (RecipientListRouterSpec)this._this();
    }

    public RecipientListRouterSpec recipient(MessageChannel channel, String expression) {
        Assert.notNull((Object)channel);
        ((DslRecipientListRouter)((Object)this.target)).add(channel, expression);
        return (RecipientListRouterSpec)this._this();
    }

    public RecipientListRouterSpec recipient(MessageChannel channel, MessageSelector selector) {
        Assert.notNull((Object)channel);
        ((DslRecipientListRouter)((Object)this.target)).add(channel, selector);
        return (RecipientListRouterSpec)this._this();
    }

    public RecipientListRouterSpec recipientFlow(MessageSelector selector, IntegrationFlow subFlow) {
        Assert.notNull((Object)subFlow);
        DirectChannel channel = this.populateSubFlow(subFlow);
        ((DslRecipientListRouter)((Object)this.target)).add((MessageChannel)channel, selector);
        return (RecipientListRouterSpec)this._this();
    }

    public RecipientListRouterSpec recipientFlow(String expression, IntegrationFlow subFlow) {
        Assert.notNull((Object)subFlow);
        DirectChannel channel = this.populateSubFlow(subFlow);
        ((DslRecipientListRouter)((Object)this.target)).add((MessageChannel)channel, expression);
        return (RecipientListRouterSpec)this._this();
    }

    private DirectChannel populateSubFlow(IntegrationFlow subFlow) {
        DirectChannel channel = new DirectChannel();
        IntegrationFlowBuilder flowBuilder = IntegrationFlows.from((MessageChannel)channel);
        subFlow.accept(flowBuilder);
        this.subFlows.add(flowBuilder.get());
        return channel;
    }

    @Override
    public Collection<Object> getComponentsToRegister() {
        return this.subFlows;
    }
}

