/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.kafka;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import kafka.serializer.Decoder;
import org.springframework.integration.dsl.core.ComponentsRegistration;
import org.springframework.integration.dsl.core.MessageSourceSpec;
import org.springframework.integration.dsl.support.Consumer;
import org.springframework.integration.dsl.support.MapBuilder;
import org.springframework.integration.dsl.support.PropertiesBuilder;
import org.springframework.integration.kafka.inbound.KafkaHighLevelConsumerMessageSource;
import org.springframework.integration.kafka.support.ConsumerConfigFactoryBean;
import org.springframework.integration.kafka.support.ConsumerConfiguration;
import org.springframework.integration.kafka.support.ConsumerConnectionProvider;
import org.springframework.integration.kafka.support.ConsumerMetadata;
import org.springframework.integration.kafka.support.KafkaConsumerContext;
import org.springframework.integration.kafka.support.MessageLeftOverTracker;
import org.springframework.integration.kafka.support.TopicFilterConfiguration;
import org.springframework.integration.kafka.support.ZookeeperConnect;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class KafkaHighLevelConsumerMessageSourceSpec
extends MessageSourceSpec<KafkaHighLevelConsumerMessageSourceSpec, KafkaHighLevelConsumerMessageSource<?, ?>>
implements ComponentsRegistration {
    private final KafkaConsumerContext consumerContext = new KafkaConsumerContext();
    private final KafkaHighLevelConsumerMessageSource kafkaHighLevelConsumerMessageSource = new KafkaHighLevelConsumerMessageSource(this.consumerContext);
    private final Map<String, ConsumerConfiguration> consumerConfigurations = new HashMap<String, ConsumerConfiguration>();
    private Properties consumerProperties;

    KafkaHighLevelConsumerMessageSourceSpec(ZookeeperConnect zookeeperConnect) {
        this.consumerContext.setZookeeperConnect(zookeeperConnect);
        this.consumerContext.setConsumerConfigurations(this.consumerConfigurations);
    }

    public KafkaHighLevelConsumerMessageSourceSpec consumerProperties(Properties consumerProperties) {
        this.consumerProperties = consumerProperties;
        return (KafkaHighLevelConsumerMessageSourceSpec)this._this();
    }

    public KafkaHighLevelConsumerMessageSourceSpec consumerProperties(Consumer<PropertiesBuilder> consumerProperties) {
        Assert.notNull(consumerProperties);
        PropertiesBuilder properties = new PropertiesBuilder();
        consumerProperties.accept(properties);
        return this.consumerProperties(properties.get());
    }

    public KafkaHighLevelConsumerMessageSourceSpec addConsumer(String groupId, Consumer<ConsumerMetadataSpec> consumerMetadataSpec) {
        Assert.hasText((String)groupId);
        Assert.notNull(consumerMetadataSpec);
        try {
            ConsumerMetadataSpec spec = new ConsumerMetadataSpec(groupId);
            consumerMetadataSpec.accept(spec);
            this.consumerConfigurations.put(groupId, spec.get());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return (KafkaHighLevelConsumerMessageSourceSpec)this._this();
    }

    @Override
    public Collection<Object> getComponentsToRegister() {
        return Collections.singleton(this.consumerContext);
    }

    @Override
    protected KafkaHighLevelConsumerMessageSource<?, ?> doGet() {
        Assert.state((!this.consumerConfigurations.isEmpty() ? 1 : 0) != 0, (String)"At least one 'Consumer' must be specified.");
        return this.kafkaHighLevelConsumerMessageSource;
    }

    public class ConsumerMetadataSpec {
        private final ConsumerMetadata consumerMetadata = new ConsumerMetadata();
        private final ConsumerConfigFactoryBean consumerConfigFactoryBean;
        private Executor executor;
        private int maxMessages;

        ConsumerMetadataSpec(String groupId) throws Exception {
            this.consumerMetadata.setGroupId(groupId);
            this.consumerConfigFactoryBean = new ConsumerConfigFactoryBean(this.consumerMetadata, KafkaHighLevelConsumerMessageSourceSpec.this.consumerContext.getZookeeperConnect(), KafkaHighLevelConsumerMessageSourceSpec.this.consumerProperties);
        }

        public ConsumerMetadataSpec consumerTimeout(int consumerTimeout) {
            this.consumerMetadata.setConsumerTimeout("" + consumerTimeout);
            return this;
        }

        public <T> ConsumerMetadataSpec valueDecoder(Decoder<T> valueDecoder) {
            this.consumerMetadata.setValueDecoder(valueDecoder);
            return this;
        }

        public <T> ConsumerMetadataSpec keyDecoder(Decoder<T> keyDecoder) {
            this.consumerMetadata.setKeyDecoder(keyDecoder);
            return this;
        }

        public ConsumerMetadataSpec topicStreamMap(Map<String, Integer> topicStreamMap) {
            this.consumerMetadata.setTopicStreamMap(topicStreamMap);
            return this;
        }

        public ConsumerMetadataSpec topicStreamMap(Consumer<MapBuilder<?, String, Integer>> topicStreamMap) {
            Assert.notNull(topicStreamMap);
            MapBuilder builder = new MapBuilder();
            topicStreamMap.accept(builder);
            return this.topicStreamMap(builder.get());
        }

        public ConsumerMetadataSpec topicFilter(String pattern, int numberOfStreams, boolean exclude) {
            this.consumerMetadata.setTopicFilterConfiguration(new TopicFilterConfiguration(pattern, numberOfStreams, exclude));
            return this;
        }

        public ConsumerMetadataSpec executor(Executor executor) {
            Assert.notNull((Object)executor);
            this.executor = executor;
            return this;
        }

        public ConsumerMetadataSpec maxMessages(int maxMessages) {
            this.maxMessages = maxMessages;
            return this;
        }

        ConsumerConfiguration get() throws Exception {
            Assert.state((boolean)(CollectionUtils.isEmpty((Map)this.consumerMetadata.getTopicStreamMap()) ^ this.consumerMetadata.getTopicFilterConfiguration() == null), (String)"One of 'topicStreamMap' or 'topicFilter' must be specified, but not both.");
            this.consumerMetadata.afterPropertiesSet();
            ConsumerConnectionProvider provider = new ConsumerConnectionProvider(this.consumerConfigFactoryBean.getObject());
            ConsumerConfiguration configuration = new ConsumerConfiguration(this.consumerMetadata, provider, new MessageLeftOverTracker());
            if (this.executor != null) {
                configuration.setExecutor(this.executor);
            }
            configuration.setMaxMessages(this.maxMessages);
            return configuration;
        }
    }
}

