/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.http;

import java.net.URI;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.dsl.http.HttpControllerEndpointSpec;
import org.springframework.integration.dsl.http.HttpMessageHandlerSpec;
import org.springframework.integration.dsl.http.HttpRequestHandlerEndpointSpec;
import org.springframework.integration.dsl.support.Function;
import org.springframework.integration.dsl.support.FunctionExpression;
import org.springframework.integration.http.inbound.HttpRequestHandlingController;
import org.springframework.integration.http.inbound.HttpRequestHandlingMessagingGateway;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public final class Http {
    public static HttpMessageHandlerSpec outboundChannelAdapter(URI uri) {
        return Http.outboundChannelAdapter(uri, null);
    }

    public static HttpMessageHandlerSpec outboundChannelAdapter(String uri) {
        return Http.outboundChannelAdapter(uri, null);
    }

    public static <P> HttpMessageHandlerSpec outboundChannelAdapter(Function<Message<P>, ?> uriFunction) {
        return Http.outboundChannelAdapter(new FunctionExpression<Message<P>>(uriFunction));
    }

    public static HttpMessageHandlerSpec outboundChannelAdapter(Expression uriExpression) {
        return Http.outboundChannelAdapter(uriExpression, null);
    }

    public static HttpMessageHandlerSpec outboundChannelAdapter(URI uri, RestTemplate restTemplate) {
        return new HttpMessageHandlerSpec(uri, restTemplate).expectReply(false);
    }

    public static HttpMessageHandlerSpec outboundChannelAdapter(String uri, RestTemplate restTemplate) {
        return new HttpMessageHandlerSpec(uri, restTemplate).expectReply(false);
    }

    public static <P> HttpMessageHandlerSpec outboundChannelAdapter(Function<Message<P>, ?> uriFunction, RestTemplate restTemplate) {
        return Http.outboundChannelAdapter(new FunctionExpression<Message<P>>(uriFunction), restTemplate);
    }

    public static HttpMessageHandlerSpec outboundChannelAdapter(Expression uriExpression, RestTemplate restTemplate) {
        return new HttpMessageHandlerSpec(uriExpression, restTemplate).expectReply(false);
    }

    public static HttpMessageHandlerSpec outboundGateway(URI uri) {
        return Http.outboundGateway(uri, null);
    }

    public static HttpMessageHandlerSpec outboundGateway(String uri) {
        return Http.outboundGateway(uri, null);
    }

    public static <P> HttpMessageHandlerSpec outboundGateway(Function<Message<P>, ?> uriFunction) {
        return Http.outboundGateway(new FunctionExpression<Message<P>>(uriFunction));
    }

    public static HttpMessageHandlerSpec outboundGateway(Expression uriExpression) {
        return Http.outboundGateway(uriExpression, null);
    }

    public static HttpMessageHandlerSpec outboundGateway(URI uri, RestTemplate restTemplate) {
        return new HttpMessageHandlerSpec(uri, restTemplate);
    }

    public static HttpMessageHandlerSpec outboundGateway(String uri, RestTemplate restTemplate) {
        return new HttpMessageHandlerSpec(uri, restTemplate);
    }

    public static <P> HttpMessageHandlerSpec outboundGateway(Function<Message<P>, ?> uriFunction, RestTemplate restTemplate) {
        return Http.outboundGateway(new FunctionExpression<Message<P>>(uriFunction), restTemplate);
    }

    public static HttpMessageHandlerSpec outboundGateway(Expression uriExpression, RestTemplate restTemplate) {
        return new HttpMessageHandlerSpec(uriExpression, restTemplate);
    }

    public static HttpControllerEndpointSpec inboundControllerAdapter(String viewName, String ... path) {
        Assert.isTrue((boolean)StringUtils.hasText((String)viewName), (String)"View name must not be empty");
        return Http.inboundControllerAdapter((Expression)new LiteralExpression(viewName), path);
    }

    public static HttpControllerEndpointSpec inboundControllerAdapter(Expression viewExpression, String ... path) {
        HttpRequestHandlingController controller = new HttpRequestHandlingController(false);
        controller.setViewExpression(viewExpression);
        return new HttpControllerEndpointSpec(controller, path);
    }

    public static HttpControllerEndpointSpec inboundControllerGateway(String viewName, String ... path) {
        Assert.isTrue((boolean)StringUtils.hasText((String)viewName), (String)"View name must not be empty");
        return Http.inboundControllerGateway((Expression)new LiteralExpression(viewName), path);
    }

    public static HttpControllerEndpointSpec inboundControllerGateway(Expression viewExpression, String ... path) {
        HttpRequestHandlingController controller = new HttpRequestHandlingController();
        controller.setViewExpression(viewExpression);
        return new HttpControllerEndpointSpec(controller, path);
    }

    public static HttpRequestHandlerEndpointSpec inboundChannelAdapter(String ... path) {
        HttpRequestHandlingMessagingGateway httpInboundChannelAdapter = new HttpRequestHandlingMessagingGateway(false);
        return new HttpRequestHandlerEndpointSpec(httpInboundChannelAdapter, path);
    }

    public static HttpRequestHandlerEndpointSpec inboundGateway(String ... path) {
        return new HttpRequestHandlerEndpointSpec(new HttpRequestHandlingMessagingGateway(), path);
    }

    private Http() {
    }
}

