/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.expression.ExpressionException;
import org.springframework.integration.jdbc.SqlParameterSourceFactory;
import org.springframework.integration.util.AbstractExpressionEvaluator;
import org.springframework.jdbc.core.namedparam.AbstractSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionEvaluatingSqlParameterSourceFactory
extends AbstractExpressionEvaluator
implements SqlParameterSourceFactory {
    private static final Log logger = LogFactory.getLog(ExpressionEvaluatingSqlParameterSourceFactory.class);
    private static final Object ERROR = new Object();
    private Map<String, ?> staticParameters = Collections.unmodifiableMap(new HashMap());

    public void setStaticParameters(Map<String, ?> staticParameters) {
        this.staticParameters = staticParameters;
    }

    @Override
    public SqlParameterSource createParameterSource(Object input) {
        ExpressionEvaluatingSqlParameterSource toReturn = new ExpressionEvaluatingSqlParameterSource(input, this.staticParameters);
        return toReturn;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExpressionEvaluatingSqlParameterSource
    extends AbstractSqlParameterSource {
        private final Object input;
        private Map<String, Object> values = new ConcurrentHashMap<String, Object>();

        private ExpressionEvaluatingSqlParameterSource(Object input, Map<String, ?> staticParameters) {
            this.input = input;
            this.values.putAll(staticParameters);
        }

        public Object getValue(String paramName) throws IllegalArgumentException {
            if (this.values.containsKey(paramName)) {
                return this.values.get(paramName);
            }
            String expression = paramName;
            if (this.input instanceof Collection) {
                expression = "#root.![" + paramName + "]";
            }
            Object value = ExpressionEvaluatingSqlParameterSourceFactory.this.evaluateExpression(expression, this.input);
            this.values.put(paramName, value);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Resolved expression " + expression + " to " + value));
            }
            return value;
        }

        public boolean hasValue(String paramName) {
            try {
                Object value = this.getValue(paramName);
                if (value == ERROR) {
                    return false;
                }
            }
            catch (ExpressionException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Could not evaluate expression", (Throwable)e);
                }
                this.values.put(paramName, ERROR);
                return false;
            }
            return true;
        }
    }
}

