/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc;

import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.Message;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.jdbc.ExpressionEvaluatingSqlParameterSourceFactory;
import org.springframework.integration.jdbc.JdbcMessageHandler;
import org.springframework.integration.jdbc.JdbcPollingChannelAdapter;
import org.springframework.integration.jdbc.SqlParameterSourceFactory;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcOutboundGateway
extends AbstractReplyProducingMessageHandler
implements InitializingBean {
    private final JdbcMessageHandler handler;
    private final JdbcPollingChannelAdapter poller;
    private volatile SqlParameterSourceFactory sqlParameterSourceFactory = new ExpressionEvaluatingSqlParameterSourceFactory();
    private volatile boolean keysGenerated;

    public JdbcOutboundGateway(DataSource dataSource, String updateQuery) {
        this((JdbcOperations)new JdbcTemplate(dataSource), updateQuery, null);
    }

    public JdbcOutboundGateway(DataSource dataSource, String updateQuery, String selectQuery) {
        this((JdbcOperations)new JdbcTemplate(dataSource), updateQuery, selectQuery);
    }

    public JdbcOutboundGateway(JdbcOperations jdbcOperations, String updateQuery) {
        this(jdbcOperations, updateQuery, null);
    }

    public JdbcOutboundGateway(JdbcOperations jdbcOperations, String updateQuery, String selectQuery) {
        if (selectQuery != null) {
            this.poller = new JdbcPollingChannelAdapter(jdbcOperations, selectQuery);
            this.poller.setMaxRowsPerPoll(1);
        } else {
            this.poller = null;
        }
        this.handler = new JdbcMessageHandler(jdbcOperations, updateQuery);
    }

    public void setMaxRowsPerPoll(int maxRows) {
        this.poller.setMaxRowsPerPoll(maxRows);
    }

    protected void onInit() {
        this.handler.afterPropertiesSet();
    }

    protected Object handleRequestMessage(Message<?> requestMessage) {
        List<Map<String, Object>> list = this.handler.executeUpdateQuery(requestMessage, this.keysGenerated);
        if (this.poller != null) {
            SqlParameterSource sqlQueryParameterSource = this.sqlParameterSourceFactory.createParameterSource(requestMessage);
            if (this.keysGenerated && !list.isEmpty()) {
                sqlQueryParameterSource = list.size() == 1 ? this.sqlParameterSourceFactory.createParameterSource(list.get(0)) : this.sqlParameterSourceFactory.createParameterSource(list);
            }
            if ((list = this.poller.doPoll(sqlQueryParameterSource)).isEmpty()) {
                return null;
            }
        }
        Object payload = list;
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            payload = list.get(0);
        }
        return MessageBuilder.withPayload(payload).copyHeaders((Map)requestMessage.getHeaders()).build();
    }

    public void setKeysGenerated(boolean keysGenerated) {
        this.keysGenerated = keysGenerated;
    }

    public void setRequestSqlParameterSourceFactory(SqlParameterSourceFactory sqlParameterSourceFactory) {
        this.handler.setSqlParameterSourceFactory(sqlParameterSourceFactory);
    }

    public void setReplySqlParameterSourceFactory(SqlParameterSourceFactory sqlParameterSourceFactory) {
        this.sqlParameterSourceFactory = sqlParameterSourceFactory;
    }

    public void setRowMapper(RowMapper<?> rowMapper) {
        this.poller.setRowMapper(rowMapper);
    }
}

