/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.Serializer;
import org.springframework.core.serializer.support.DeserializingConverter;
import org.springframework.core.serializer.support.SerializingConverter;
import org.springframework.dao.DataAccessException;
import org.springframework.integration.Message;
import org.springframework.integration.store.AbstractMessageGroupStore;
import org.springframework.integration.store.MessageGroup;
import org.springframework.integration.store.MessageStore;
import org.springframework.integration.store.SimpleMessageGroup;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.integration.util.UUIDConverter;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedResource
public class JdbcMessageStore
extends AbstractMessageGroupStore
implements MessageStore {
    private static final Log logger = LogFactory.getLog(JdbcMessageStore.class);
    public static final String DEFAULT_TABLE_PREFIX = "INT_";
    private static final String GET_MESSAGE = "SELECT MESSAGE_ID, CREATED_DATE, MESSAGE_BYTES from %PREFIX%MESSAGE where MESSAGE_ID=? and REGION=?";
    private static final String GET_GROUP_CREATED_DATE = "SELECT CREATED_DATE from %PREFIX%MESSAGE_GROUP where GROUP_KEY=? and REGION=?";
    private static final String GET_MESSAGE_COUNT = "SELECT COUNT(MESSAGE_ID) from %PREFIX%MESSAGE where REGION=?";
    private static final String DELETE_MESSAGE = "DELETE from %PREFIX%MESSAGE where MESSAGE_ID=? and REGION=?";
    private static final String CREATE_MESSAGE = "INSERT into %PREFIX%MESSAGE(MESSAGE_ID, REGION, CREATED_DATE, MESSAGE_BYTES) values (?, ?, ?, ?)";
    private static final String LIST_MESSAGES_BY_GROUP_KEY = "SELECT MESSAGE_ID, CREATED_DATE, UPDATED_DATE, GROUP_KEY, MESSAGE_BYTES, MARKED, COMPLETE, LAST_RELEASED_SEQUENCE from %PREFIX%MESSAGE_GROUP where GROUP_KEY=? and REGION=? order by UPDATED_DATE";
    private static final String LIST_MESSAGEIDS_BY_GROUP_KEY = "SELECT MESSAGE_ID, CREATED_DATE from %PREFIX%MESSAGE_GROUP where GROUP_KEY=? and REGION=? order by UPDATED_DATE";
    private static final String COUNT_ALL_GROUPS = "SELECT COUNT(GROUP_KEY) from %PREFIX%MESSAGE_GROUP where REGION=?";
    private static final String COUNT_ALL_MESSAGES_IN_GROUP = "SELECT COUNT(MESSAGE_ID) from %PREFIX%MESSAGE_GROUP where GROUP_KEY=? AND REGION=?";
    private static final String COUNT_ALL_MESSAGES_IN_GROUPS = "SELECT COUNT(MESSAGE_ID) from %PREFIX%MESSAGE_GROUP where REGION=?";
    private static final String COMPLETE_GROUP = "UPDATE %PREFIX%MESSAGE_GROUP set UPDATED_DATE=?, COMPLETE=1 where GROUP_KEY=? and REGION=?";
    private static final String UPDATE_LAST_RELEASED_SEQUENCE = "UPDATE %PREFIX%MESSAGE_GROUP set UPDATED_DATE=?, LAST_RELEASED_SEQUENCE=? where GROUP_KEY=? and REGION=?";
    private static final String REMOVE_MESSAGE_FROM_GROUP = "DELETE from %PREFIX%MESSAGE_GROUP where GROUP_KEY=? and REGION=? and MESSAGE_ID=?";
    private static final String DELETE_MESSAGE_GROUP = "DELETE from %PREFIX%MESSAGE_GROUP where GROUP_KEY=? and REGION=?";
    private static final String CREATE_MESSAGE_IN_GROUP = "INSERT into %PREFIX%MESSAGE_GROUP(MESSAGE_ID, REGION, CREATED_DATE, UPDATED_DATE, GROUP_KEY, MARKED, COMPLETE, LAST_RELEASED_SEQUENCE) values (?, ?, ?, ?, ?, 0, 0, 0)";
    private static final String UPDATE_GROUP = "UPDATE %PREFIX%MESSAGE_GROUP set UPDATED_DATE=? where GROUP_KEY=? and REGION=?";
    private static final String LIST_GROUP_KEYS = "SELECT distinct GROUP_KEY as CREATED from %PREFIX%MESSAGE_GROUP where REGION=?";
    public static final int DEFAULT_LONG_STRING_LENGTH = 2500;
    public static final String SAVED_KEY = JdbcMessageStore.class.getSimpleName() + ".SAVED";
    public static final String CREATED_DATE_KEY = JdbcMessageStore.class.getSimpleName() + ".CREATED_DATE";
    private volatile String region = "DEFAULT";
    private volatile String tablePrefix = "INT_";
    private volatile JdbcOperations jdbcTemplate;
    private volatile DeserializingConverter deserializer;
    private volatile SerializingConverter serializer;
    private volatile LobHandler lobHandler = new DefaultLobHandler();
    private volatile MessageMapper mapper = new MessageMapper();

    public JdbcMessageStore() {
        this.deserializer = new DeserializingConverter();
        this.serializer = new SerializingConverter();
    }

    public JdbcMessageStore(DataSource dataSource) {
        this();
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    protected String getQuery(String base) {
        return StringUtils.replace((String)base, (String)"%PREFIX%", (String)this.tablePrefix);
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public void setJdbcTemplate(JdbcOperations jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public void setLobHandler(LobHandler lobHandler) {
        this.lobHandler = lobHandler;
    }

    public void setSerializer(Serializer<? super Message<?>> serializer) {
        this.serializer = new SerializingConverter(serializer);
    }

    public void setDeserializer(Deserializer<? extends Message<?>> deserializer) {
        this.deserializer = new DeserializingConverter(deserializer);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.jdbcTemplate != null ? 1 : 0) != 0, (String)"A DataSource or JdbcTemplate must be provided");
    }

    public Message<?> removeMessage(UUID id) {
        Message<?> message = this.getMessage(id);
        if (message == null) {
            return null;
        }
        int updated = this.jdbcTemplate.update(this.getQuery(DELETE_MESSAGE), new Object[]{this.getKey(id), this.region}, new int[]{12, 12});
        if (updated != 0) {
            return message;
        }
        return null;
    }

    @ManagedAttribute
    public long getMessageCount() {
        return this.jdbcTemplate.queryForInt(this.getQuery(GET_MESSAGE_COUNT), new Object[]{this.region});
    }

    public Message<?> getMessage(UUID id) {
        List list = this.jdbcTemplate.query(this.getQuery(GET_MESSAGE), new Object[]{this.getKey(id), this.region}, (RowMapper)this.mapper);
        if (list.isEmpty()) {
            return null;
        }
        return (Message)list.get(0);
    }

    public <T> Message<T> addMessage(Message<T> message) {
        Message<?> saved;
        if (message.getHeaders().containsKey((Object)SAVED_KEY) && (saved = this.getMessage(message.getHeaders().getId())) != null && saved.equals(message)) {
            return message;
        }
        final long createdDate = System.currentTimeMillis();
        Message result = MessageBuilder.fromMessage(message).setHeader(SAVED_KEY, (Object)Boolean.TRUE).setHeader(CREATED_DATE_KEY, (Object)new Long(createdDate)).build();
        Map innerMap = (Map)new DirectFieldAccessor((Object)result.getHeaders()).getPropertyValue("headers");
        innerMap.put("id", message.getHeaders().get((Object)"id"));
        final String messageId = this.getKey(result.getHeaders().getId());
        final byte[] messageBytes = this.serializer.convert((Object)result);
        this.jdbcTemplate.update(this.getQuery(CREATE_MESSAGE), new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                logger.debug((Object)("Inserting message with id key=" + messageId));
                ps.setString(1, messageId);
                ps.setString(2, JdbcMessageStore.this.region);
                ps.setTimestamp(3, new Timestamp(createdDate));
                JdbcMessageStore.this.lobHandler.getLobCreator().setBlobAsBytes(ps, 4, messageBytes);
            }
        });
        return result;
    }

    public MessageGroup addMessageToGroup(Object groupId, Message<?> message) {
        final String groupKey = this.getKey(groupId);
        final long updatedDate = System.currentTimeMillis();
        final long createdDate = this.getGroupCreatedDate(groupKey);
        final String messageId = this.getKey(message.getHeaders().getId());
        this.jdbcTemplate.update(this.getQuery(CREATE_MESSAGE_IN_GROUP), new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                logger.debug((Object)("Inserting message with id key=" + messageId + " and created date=" + createdDate));
                ps.setString(1, messageId);
                ps.setString(2, JdbcMessageStore.this.region);
                if (createdDate == 0L) {
                    ps.setTimestamp(3, new Timestamp(updatedDate));
                } else {
                    ps.setTimestamp(3, new Timestamp(createdDate));
                }
                ps.setTimestamp(4, new Timestamp(updatedDate));
                ps.setString(5, groupKey);
            }
        });
        this.addMessage(message);
        return this.getMessageGroup(groupId);
    }

    @ManagedAttribute
    public int getMessageGroupCount() {
        return this.jdbcTemplate.queryForInt(this.getQuery(COUNT_ALL_GROUPS), new Object[]{this.region});
    }

    @ManagedAttribute
    public int getMessageCountForAllMessageGroups() {
        return this.jdbcTemplate.queryForInt(this.getQuery(COUNT_ALL_MESSAGES_IN_GROUPS), new Object[]{this.region});
    }

    @ManagedAttribute
    public int messageGroupSize(Object groupId) {
        String key = this.getKey(groupId);
        return this.jdbcTemplate.queryForInt(this.getQuery(COUNT_ALL_MESSAGES_IN_GROUP), new Object[]{key, this.region});
    }

    public MessageGroup getMessageGroup(Object groupId) {
        int lastReleasedSequenceNumber;
        String key = this.getKey(groupId);
        final ArrayList messages = new ArrayList();
        final AtomicReference date = new AtomicReference();
        final AtomicReference updateDate = new AtomicReference();
        final AtomicReference completeFlag = new AtomicReference();
        final AtomicReference lastReleasedSequenceRef = new AtomicReference();
        final AtomicInteger size = new AtomicInteger();
        this.jdbcTemplate.query(this.getQuery(LIST_MESSAGES_BY_GROUP_KEY), new Object[]{key, this.region}, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                size.incrementAndGet();
                messages.add(JdbcMessageStore.this.getMessage(UUID.fromString(rs.getString("MESSAGE_ID"))));
                date.set(rs.getTimestamp("CREATED_DATE"));
                updateDate.set(rs.getTimestamp("UPDATED_DATE"));
                completeFlag.set(rs.getInt("COMPLETE") > 0);
                lastReleasedSequenceRef.set(rs.getInt("LAST_RELEASED_SEQUENCE"));
            }
        });
        if (size.get() == 0) {
            return new SimpleMessageGroup(groupId);
        }
        Assert.state((date.get() != null ? 1 : 0) != 0, (String)("Could not locate created date for groupId=" + groupId));
        Assert.state((updateDate.get() != null ? 1 : 0) != 0, (String)("Could not locate updated date for groupId=" + groupId));
        long timestamp = ((Date)date.get()).getTime();
        boolean complete = (Boolean)completeFlag.get();
        SimpleMessageGroup messageGroup = new SimpleMessageGroup(messages, groupId, timestamp, complete);
        if (updateDate.get() != null) {
            messageGroup.setLastModified(((Date)updateDate.get()).getTime());
        }
        if ((lastReleasedSequenceNumber = ((Integer)lastReleasedSequenceRef.get()).intValue()) > 0) {
            messageGroup.setLastReleasedMessageSequenceNumber(lastReleasedSequenceNumber);
        }
        return messageGroup;
    }

    public MessageGroup removeMessageFromGroup(Object groupId, Message<?> messageToRemove) {
        final String groupKey = this.getKey(groupId);
        final String messageId = this.getKey(messageToRemove.getHeaders().getId());
        this.jdbcTemplate.update(this.getQuery(REMOVE_MESSAGE_FROM_GROUP), new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                logger.debug((Object)("Removing message from group with group key=" + groupKey));
                ps.setString(1, groupKey);
                ps.setString(2, JdbcMessageStore.this.region);
                ps.setString(3, messageId);
            }
        });
        this.removeMessage(messageToRemove.getHeaders().getId());
        this.updateMessageGroup(groupKey);
        return this.getMessageGroup(groupId);
    }

    public void removeMessageGroup(Object groupId) {
        final String groupKey = this.getKey(groupId);
        for (UUID messageIds : this.getMessageIdsForGroup(groupId)) {
            this.removeMessage(messageIds);
        }
        this.jdbcTemplate.update(this.getQuery(DELETE_MESSAGE_GROUP), new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                logger.debug((Object)("Marking messages with group key=" + groupKey));
                ps.setString(1, groupKey);
                ps.setString(2, JdbcMessageStore.this.region);
            }
        });
    }

    public void completeGroup(Object groupId) {
        final long updatedDate = System.currentTimeMillis();
        final String groupKey = this.getKey(groupId);
        this.jdbcTemplate.update(this.getQuery(COMPLETE_GROUP), new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                logger.debug((Object)("Completing MessageGroup: " + groupKey));
                ps.setTimestamp(1, new Timestamp(updatedDate));
                ps.setString(2, groupKey);
                ps.setString(3, JdbcMessageStore.this.region);
            }
        });
    }

    public void setLastReleasedSequenceNumberForGroup(Object groupId, final int sequenceNumber) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        final long updatedDate = System.currentTimeMillis();
        final String groupKey = this.getKey(groupId);
        this.jdbcTemplate.update(this.getQuery(UPDATE_LAST_RELEASED_SEQUENCE), new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                logger.debug((Object)("Updating  the sequence number of the last released Message in the MessageGroup: " + groupKey));
                ps.setTimestamp(1, new Timestamp(updatedDate));
                ps.setInt(2, sequenceNumber);
                ps.setString(3, groupKey);
                ps.setString(4, JdbcMessageStore.this.region);
            }
        });
        this.updateMessageGroup(groupKey);
    }

    public Message<?> pollMessageFromGroup(final Object groupId) {
        String key = this.getKey(groupId);
        Message message = (Message)this.jdbcTemplate.query(this.getQuery(LIST_MESSAGEIDS_BY_GROUP_KEY), new Object[]{key, this.region}, new ResultSetExtractor<Message<?>>(){

            public Message<?> extractData(ResultSet rs) throws SQLException, DataAccessException {
                while (rs.next()) {
                    Message<?> message;
                    UUID uuid = UUID.fromString(rs.getString(1));
                    if (uuid == null || (message = JdbcMessageStore.this.getMessage(uuid)) == null) continue;
                    JdbcMessageStore.this.removeMessageFromGroup(groupId, message);
                    return message;
                }
                return null;
            }
        });
        this.updateMessageGroup(key);
        return message;
    }

    public Iterator<MessageGroup> iterator() {
        final Iterator iterator = this.jdbcTemplate.query(this.getQuery(LIST_GROUP_KEYS), new Object[]{this.region}, (RowMapper)new SingleColumnRowMapper()).iterator();
        return new Iterator<MessageGroup>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public MessageGroup next() {
                return JdbcMessageStore.this.getMessageGroup(iterator.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot remove MessageGroup from this iterator.");
            }
        };
    }

    private void updateMessageGroup(final String groupId) {
        this.jdbcTemplate.update(this.getQuery(UPDATE_GROUP), new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                logger.debug((Object)("Updating MessageGroup: " + groupId));
                ps.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
                ps.setString(2, groupId);
                ps.setString(3, JdbcMessageStore.this.region);
            }
        });
    }

    private List<UUID> getMessageIdsForGroup(Object groupId) {
        String key = this.getKey(groupId);
        final ArrayList<UUID> messageIds = new ArrayList<UUID>();
        this.jdbcTemplate.query(this.getQuery(LIST_MESSAGEIDS_BY_GROUP_KEY), new Object[]{key, this.region}, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                messageIds.add(UUID.fromString(rs.getString(1)));
            }
        });
        return messageIds;
    }

    private String getKey(Object input) {
        return input == null ? null : UUIDConverter.getUUID((Object)input).toString();
    }

    private long getGroupCreatedDate(String groupKey) {
        final AtomicReference date = new AtomicReference();
        this.jdbcTemplate.query(this.getQuery(GET_GROUP_CREATED_DATE), new Object[]{groupKey, this.region}, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                date.set(rs.getTimestamp("CREATED_DATE").getTime());
            }
        });
        Long returnedDate = (Long)date.get();
        if (returnedDate == null) {
            return 0L;
        }
        return returnedDate;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MessageMapper
    implements RowMapper<Message<?>> {
        private MessageMapper() {
        }

        public Message<?> mapRow(ResultSet rs, int rowNum) throws SQLException {
            Message message = (Message)JdbcMessageStore.this.deserializer.convert(JdbcMessageStore.this.lobHandler.getBlobAsBytes(rs, "MESSAGE_BYTES"));
            return message;
        }
    }
}

