/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.Message;
import org.springframework.integration.jdbc.BeanPropertySqlParameterSourceFactory;
import org.springframework.integration.jdbc.ExpressionEvaluatingSqlParameterSourceFactory;
import org.springframework.integration.jdbc.SqlParameterSourceFactory;
import org.springframework.integration.jdbc.storedproc.ProcedureParameter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.SimpleJdbcCall;
import org.springframework.jdbc.core.simple.SimpleJdbcCallOperations;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoredProcExecutor
implements InitializingBean {
    private final SimpleJdbcCall jdbcCallOperations;
    private volatile String storedProcedureName;
    private volatile boolean ignoreColumnMetaData = false;
    private volatile boolean skipUndeclaredResults = true;
    private volatile List<SqlParameter> sqlParameters = new ArrayList<SqlParameter>(0);
    private volatile SqlParameterSourceFactory sqlParameterSourceFactory = null;
    private volatile Boolean usePayloadAsParameterSource = null;
    private volatile List<ProcedureParameter> procedureParameters;
    private volatile boolean isFunction = false;
    private volatile boolean returnValueRequired = false;
    private volatile Map<String, RowMapper<?>> returningResultSetRowMappers = new HashMap(0);

    public StoredProcExecutor(DataSource dataSource, String storedProcedureName) {
        Assert.notNull((Object)dataSource, (String)"dataSource must not be null.");
        Assert.hasText((String)storedProcedureName, (String)"storedProcedureName must not be null and cannot be empty.");
        this.jdbcCallOperations = new SimpleJdbcCall(dataSource);
        this.storedProcedureName = storedProcedureName;
    }

    public void afterPropertiesSet() {
        if (this.procedureParameters != null) {
            if (this.sqlParameterSourceFactory == null) {
                ExpressionEvaluatingSqlParameterSourceFactory expressionSourceFactory = new ExpressionEvaluatingSqlParameterSourceFactory();
                expressionSourceFactory.setStaticParameters(ProcedureParameter.convertStaticParameters(this.procedureParameters));
                expressionSourceFactory.setParameterExpressions(ProcedureParameter.convertExpressions(this.procedureParameters));
                this.sqlParameterSourceFactory = expressionSourceFactory;
            } else if (!(this.sqlParameterSourceFactory instanceof ExpressionEvaluatingSqlParameterSourceFactory)) {
                throw new IllegalStateException("You are providing 'ProcedureParameters'. Was expecting the the provided sqlParameterSourceFactory to be an instance of 'ExpressionEvaluatingSqlParameterSourceFactory', however the provided one is of type '" + this.sqlParameterSourceFactory.getClass().getName() + "'");
            }
            if (this.usePayloadAsParameterSource == null) {
                this.usePayloadAsParameterSource = false;
            }
        } else {
            if (this.sqlParameterSourceFactory == null) {
                this.sqlParameterSourceFactory = new BeanPropertySqlParameterSourceFactory();
            }
            if (this.usePayloadAsParameterSource == null) {
                this.usePayloadAsParameterSource = true;
            }
        }
        if (this.ignoreColumnMetaData) {
            this.jdbcCallOperations.withoutProcedureColumnMetaDataAccess();
        }
        this.jdbcCallOperations.declareParameters(this.sqlParameters.toArray(new SqlParameter[this.sqlParameters.size()]));
        if (!this.returningResultSetRowMappers.isEmpty()) {
            for (Map.Entry<String, RowMapper<?>> mapEntry : this.returningResultSetRowMappers.entrySet()) {
                this.jdbcCallOperations.returningResultSet(mapEntry.getKey(), mapEntry.getValue());
            }
        }
        if (this.returnValueRequired) {
            this.jdbcCallOperations.withReturnValue();
        }
        if (this.isFunction) {
            this.jdbcCallOperations.withFunctionName(this.storedProcedureName);
        } else {
            this.jdbcCallOperations.withProcedureName(this.storedProcedureName);
        }
        this.jdbcCallOperations.getJdbcTemplate().setSkipUndeclaredResults(this.skipUndeclaredResults);
    }

    public Map<String, Object> executeStoredProcedure() {
        return this.executeStoredProcedureInternal(new Object());
    }

    public Map<String, Object> executeStoredProcedure(Message<?> message) {
        Assert.notNull(message, (String)"The message parameter must not be null.");
        Assert.notNull((Object)this.usePayloadAsParameterSource, (String)"Property usePayloadAsParameterSource was Null. Did you call afterPropertiesSet()?");
        if (this.usePayloadAsParameterSource.booleanValue()) {
            return this.executeStoredProcedureInternal(message.getPayload());
        }
        return this.executeStoredProcedureInternal(message);
    }

    private Map<String, Object> executeStoredProcedureInternal(Object input) {
        Assert.notNull((Object)this.sqlParameterSourceFactory, (String)"Property sqlParameterSourceFactory was Null. Did you call afterPropertiesSet()?");
        SqlParameterSource storedProcedureParameterSource = this.sqlParameterSourceFactory.createParameterSource(input);
        return StoredProcExecutor.executeStoredProcedure((SimpleJdbcCallOperations)this.jdbcCallOperations, storedProcedureParameterSource);
    }

    private static Map<String, Object> executeStoredProcedure(SimpleJdbcCallOperations simpleJdbcCallOperations, SqlParameterSource storedProcedureParameterSource) {
        Map resultMap = simpleJdbcCallOperations.execute(storedProcedureParameterSource);
        return resultMap;
    }

    public void setIgnoreColumnMetaData(boolean ignoreColumnMetaData) {
        this.ignoreColumnMetaData = ignoreColumnMetaData;
    }

    public void setProcedureParameters(List<ProcedureParameter> procedureParameters) {
        Assert.notEmpty(procedureParameters, (String)"procedureParameters must not be null or empty.");
        for (ProcedureParameter procedureParameter : procedureParameters) {
            Assert.notNull((Object)procedureParameter, (String)"The provided list (procedureParameters) cannot contain null values.");
        }
        this.procedureParameters = procedureParameters;
    }

    public void setSqlParameters(List<SqlParameter> sqlParameters) {
        Assert.notEmpty(sqlParameters, (String)"sqlParameters must not be null or empty.");
        for (SqlParameter sqlParameter : sqlParameters) {
            Assert.notNull((Object)sqlParameter, (String)"The provided list (sqlParameters) cannot contain null values.");
        }
        this.sqlParameters = sqlParameters;
    }

    public void setSqlParameterSourceFactory(SqlParameterSourceFactory sqlParameterSourceFactory) {
        Assert.notNull((Object)sqlParameterSourceFactory, (String)"sqlParameterSourceFactory must not be null.");
        this.sqlParameterSourceFactory = sqlParameterSourceFactory;
    }

    public String getStoredProcedureName() {
        return this.storedProcedureName;
    }

    public void setUsePayloadAsParameterSource(boolean usePayloadAsParameterSource) {
        this.usePayloadAsParameterSource = usePayloadAsParameterSource;
    }

    public void setFunction(boolean isFunction) {
        this.isFunction = isFunction;
    }

    public void setReturnValueRequired(boolean returnValueRequired) {
        this.returnValueRequired = returnValueRequired;
    }

    public void setSkipUndeclaredResults(boolean skipUndeclaredResults) {
        this.skipUndeclaredResults = skipUndeclaredResults;
    }

    public void setReturningResultSetRowMappers(Map<String, RowMapper<?>> returningResultSetRowMappers) {
        Assert.notNull(returningResultSetRowMappers, (String)"returningResultSetRowMappers must not be null.");
        for (RowMapper<?> rowMapper : returningResultSetRowMappers.values()) {
            Assert.notNull(rowMapper, (String)"The provided map cannot contain null values.");
        }
        this.returningResultSetRowMappers = returningResultSetRowMappers;
    }
}

